/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 17, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.router.commands.annotations;

import gov.va.med.RoutingToken;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.ImageAnnotationURN;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.router.AbstractDataSourceCommandImpl;
import gov.va.med.imaging.datasource.ImageAnnotationDataSourceSpi;
import gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails;

/**
 * @author       DNS
 *
 */
public class GetImageAnnotationDetailsCommandImpl
extends AbstractDataSourceCommandImpl<ImageAnnotationDetails, ImageAnnotationDataSourceSpi>
{
	private static final long serialVersionUID = 5588995673006440151L;

	private final ImageAnnotationURN imageAnnotationUrn;
	private final AbstractImagingURN imagingUrn;
	
	private static final String SPI_METHOD_NAME = "getAnnotationDetails";
	private static final Class<?>[] SPI_METHOD_PARAMETER_TYPES = 
		new Class<?>[]{AbstractImagingURN.class, ImageAnnotationURN.class};
	
	public GetImageAnnotationDetailsCommandImpl(AbstractImagingURN imagingUrn, 
			ImageAnnotationURN imageAnnotationUrn)
	{
		this.imageAnnotationUrn = imageAnnotationUrn;
		this.imagingUrn = imagingUrn;
	}

	public ImageAnnotationURN getImageAnnotationUrn()
	{
		return imageAnnotationUrn;
	}

	public AbstractImagingURN getImagingUrn()
	{
		return imagingUrn;
	}

	@Override
	public RoutingToken getRoutingToken()
	{
		return getImagingUrn();
	}

	@Override
	protected Class<ImageAnnotationDataSourceSpi> getSpiClass()
	{
		return ImageAnnotationDataSourceSpi.class;
	}

	@Override
	protected String getSpiMethodName()
	{
		return SPI_METHOD_NAME;
	}

	@Override
	protected Class<?>[] getSpiMethodParameterTypes()
	{
		return SPI_METHOD_PARAMETER_TYPES;
	}

	@Override
	protected Object[] getSpiMethodParameters()
	{
		return new Object [] {getImagingUrn(), getImageAnnotationUrn()};
	}

	@Override
	protected String getSiteNumber()
	{
		return getRoutingToken().getRepositoryUniqueId();
	}

	@Override
	protected ImageAnnotationDetails getCommandResult(
			ImageAnnotationDataSourceSpi spi) 
	throws ConnectionException, MethodException
	{
		return spi.getAnnotationDetails(getImagingUrn(), getImageAnnotationUrn());
	}
	

}
