/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.router.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class ImagingRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public ImagingRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImageAccessEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImageAccessEventFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostImageAccessEventFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  			},
 					new Object[]{
				 		routingToken,event
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImageAccessEventFromDataSourceCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImageAccessEventRetryable(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostImageAccessEventRetryableCommand' and parameters 'gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostImageAccessEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  		},
				new Object[]{
			 		event
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostImageAccessEventRetryableCommand' in method 'postImageAccessEventRetryable' with parameters 'gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PrefetchInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PrefetchInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PrefetchInstanceByImageUrnCommand' in method 'prefetchInstanceByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchInstanceByImageUrnDelayOneMinute(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PrefetchInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PrefetchInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PrefetchInstanceByImageUrnCommand' in method 'prefetchInstanceByImageUrnDelayOneMinute' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamInstanceByImageUrnDelayOneMinute(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PrefetchExamInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PrefetchExamInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PrefetchExamInstanceByImageUrnCommand' in method 'prefetchExamInstanceByImageUrnDelayOneMinute' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetListBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener<?> listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetDocumentSetListBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetDocumentSetListBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  		},
				new Object[]{
			 		routingToken,filter
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetDocumentSetListBySiteNumberCommand' in method 'getDocumentSetListBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyFromCprsIdentifier(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, gov.va.med.imaging.CprsIdentifier cprsIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudiesByCprsIdentifierFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, gov.va.med.imaging.CprsIdentifier'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudiesByCprsIdentifierFromDataSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, gov.va.med.imaging.CprsIdentifier.class 
	  			},
				new Object[]{
			 		routingToken,patientIcn,cprsIdentifier
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudiesByCprsIdentifierFromDataSourceCommand' in method 'getStudyFromCprsIdentifier' with parameters 'gov.va.med.RoutingToken, java.lang.String, gov.va.med.imaging.CprsIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientEnterpriseExams(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, java.lang.Boolean fullyLoadExams
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientEnterpriseExamsCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams.class, 
	 				"GetPatientEnterpriseExamsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,fullyLoadExams
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientEnterpriseExamsCommand' in method 'getPatientEnterpriseExams' with parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientRegistration(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientRegistrationCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.PatientRegistration.class, 
	 				"GetPatientRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientRegistrationCommand' in method 'getPatientRegistration' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getRelevantPriorCptCodes(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String cptCode
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetRelevantPriorCptCodesCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String[].class, 
	 				"GetRelevantPriorCptCodesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,cptCode
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetRelevantPriorCptCodesCommand' in method 'getRelevantPriorCptCodes' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PrefetchExamImagesAsyncCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PrefetchExamImagesAsyncCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.StudyURN.class 
		  		},
				new Object[]{
			 		studyUrn
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PrefetchExamImagesAsyncCommand' in method 'prefetchExamImages' with parameters 'gov.va.med.imaging.StudyURN'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"GetExamInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamInstanceByImageUrnCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class 
		  			},
 					new Object[]{
				 		imageUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileByImageUrnCommand' in method 'getExamTextFileByImageUrn' with parameters 'gov.va.med.imaging.ImageURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,imageMetadataNotification,outStream
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileByImageUrnCommand' in method 'getExamTextFileByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getFullyLoadedExamSite(
 			gov.va.med.RoutingToken routingToken
 			, java.lang.String patientIcn
 			, boolean forceRefresh
 			, boolean forceImagesFromJb
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetFullyLoadedExamSiteBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetFullyLoadedExamSiteBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetFullyLoadedExamSiteBySiteNumberCommand' in method 'getFullyLoadedExamSite' with parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getFullyLoadedExamSite(
 			gov.va.med.RoutingToken routingToken
 			, java.lang.String patientIcn
 			, boolean forceRefresh
 			, boolean forceImagesFromJb
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetFullyLoadedExamSiteBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetFullyLoadedExamSiteBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetFullyLoadedExamSiteBySiteNumberCommand' in method 'getFullyLoadedExamSite' with parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamSiteBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, java.lang.String patientIcn
 			, java.lang.Boolean forceRefresh
 			, java.lang.Boolean forceImagesFromJb
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetExamSiteBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean, java.lang.Boolean'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetExamSiteBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetExamSiteBySiteNumberCommand' in method 'getExamSiteBySiteNumber' with parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean, java.lang.Boolean'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileFromDataSource(
 			gov.va.med.imaging.ImageURN imageUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileByImageUrnFromDataSourceCommand' and parameters 'gov.va.med.imaging.ImageURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetExamTextFileByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class 
		  			},
 					new Object[]{
				 		imageUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileByImageUrnFromDataSourceCommand' in method 'getExamTextFileFromDataSource' with parameters 'gov.va.med.imaging.ImageURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileFromDataSource(
 			gov.va.med.imaging.exchange.business.vistarad.ExamImage examImage
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileByExamImageFromDataSourceCommand' and parameters 'gov.va.med.imaging.exchange.business.vistarad.ExamImage'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetExamTextFileByExamImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.vistarad.ExamImage.class 
		  			},
 					new Object[]{
				 		examImage
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileByExamImageFromDataSourceCommand' in method 'getExamTextFileFromDataSource' with parameters 'gov.va.med.imaging.exchange.business.vistarad.ExamImage'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceFromDataSource(
 			gov.va.med.imaging.exchange.business.vistarad.ExamImage image
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQuality
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamInstanceByExamImageFromDataSourceCommand' and parameters 'gov.va.med.imaging.exchange.business.vistarad.ExamImage, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetExamInstanceByExamImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.vistarad.ExamImage.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		image,requestFormatQuality
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamInstanceByExamImageFromDataSourceCommand' in method 'getExamInstanceFromDataSource' with parameters 'gov.va.med.imaging.exchange.business.vistarad.ExamImage, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceFromDataSource(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQuality
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamInstanceByImageUrnFromDataSourceCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetExamInstanceByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,requestFormatQuality
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamInstanceByImageUrnFromDataSourceCommand' in method 'getExamInstanceFromDataSource' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamReportFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamReportFromDataSourceCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetExamReportFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamReportFromDataSourceCommand' in method 'getExamReportFromDataSource' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamRequisitionReportFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamRequisitionReportFromDataSourceCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetExamRequisitionReportFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamRequisitionReportFromDataSourceCommand' in method 'getExamRequisitionReportFromDataSource' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamsForPatientFromDataSource(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, boolean fullyLoadExams
 		 			, boolean forceRefresh
 		 			, boolean forceImagesFromJb
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamsForPatientFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamListResult.class, 
	 				"GetExamsForPatientFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, boolean.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,fullyLoadExams,forceRefresh,forceImagesFromJb
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamsForPatientFromDataSourceCommand' in method 'getExamsForPatientFromDataSource' with parameters 'gov.va.med.RoutingToken, java.lang.String, boolean, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamImagesForExamFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamImagesForExamFromDataSourceCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamImages.class, 
	 				"GetExamImagesForExamFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamImagesForExamFromDataSourceCommand' in method 'getExamImagesForExamFromDataSource' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamFromDataSourceCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.Exam.class, 
	 				"GetExamFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamFromDataSourceCommand' in method 'getExamFromDataSource' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientDocumentSets(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientDocumentSetsDataSourceCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, gov.va.med.imaging.exchange.business.DocumentFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetPatientDocumentSetsDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,filter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientDocumentSetsDataSourceCommand' in method 'getPatientDocumentSets' with parameters 'gov.va.med.RoutingToken, java.lang.String, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentFromDataSource(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentFromDataSourceCommand' and parameters 'gov.va.med.GlobalArtifactIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetDocumentFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class 
		  			},
 					new Object[]{
				 		documentIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentFromDataSourceCommand' in method 'getDocumentFromDataSource' with parameters 'gov.va.med.GlobalArtifactIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQualityList
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetInstanceByImageUrnFromDataSourceCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetInstanceByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,requestFormatQualityList
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetInstanceByImageUrnFromDataSourceCommand' in method 'getInstanceByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getInstanceByImage(
 			gov.va.med.imaging.exchange.business.Image image
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQualityList
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetInstanceByImageFromDataSourceCommand' and parameters 'gov.va.med.imaging.exchange.business.Image, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetInstanceByImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.Image.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		image,requestFormatQualityList
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetInstanceByImageFromDataSourceCommand' in method 'getInstanceByImage' with parameters 'gov.va.med.imaging.exchange.business.Image, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getInstanceTextFileByImage(
 			gov.va.med.imaging.exchange.business.Image image
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetInstanceTextFileByImageFromDataSourceCommand' and parameters 'gov.va.med.imaging.exchange.business.Image'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetInstanceTextFileByImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.Image.class 
		  			},
 					new Object[]{
				 		image
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetInstanceTextFileByImageFromDataSourceCommand' in method 'getInstanceTextFileByImage' with parameters 'gov.va.med.imaging.exchange.business.Image'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getInstanceTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetInstanceTextFileByImageUrnFromDataSourceCommand' and parameters 'gov.va.med.imaging.ImageURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetInstanceTextFileByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class 
		  			},
 					new Object[]{
				 		imageUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetInstanceTextFileByImageUrnFromDataSourceCommand' in method 'getInstanceTextFileByImageUrn' with parameters 'gov.va.med.imaging.ImageURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyList(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetStudyListBySiteCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetStudyListBySiteCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudyListBySiteCommand' in method 'getStudyList' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySet(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudySetBySiteNumberFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetBySiteNumberFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,studyLoadLevel
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudySetBySiteNumberFromDataSourceCommand' in method 'getStudySet' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientIdentificationImage(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientIdentificationImageFromDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.io.InputStream.class, 
	 				"GetPatientIdentificationImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientIdentificationImageFromDataSourceCommand' in method 'getPatientIdentificationImage' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultWithImagesBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetStudySetResultWithImagesBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetStudySetResultWithImagesBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudySetResultWithImagesBySiteNumberCommand' in method 'getStudySetResultWithImagesBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultWithReportsBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetShallowStudySetWithReportBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetShallowStudySetWithReportBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetShallowStudySetWithReportBySiteNumberCommand' in method 'getStudySetResultWithReportsBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getShallowStudySetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetShallowStudySetResultBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetShallowStudySetResultBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetShallowStudySetResultBySiteNumberCommand' in method 'getShallowStudySetResultBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetStudySetResultBySiteCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetStudySetResultBySiteCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudySetResultBySiteCommand' in method 'getStudySetResultBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCumulativeStatisticsStudySetResultForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCumulativeStatisticsStudySetResultForPatientCommand' and parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics.class, 
	 				"GetCumulativeStatisticsStudySetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter,studyLoadLevel
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCumulativeStatisticsStudySetResultForPatientCommand' in method 'getCumulativeStatisticsStudySetResultForPatient' with parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener<?> listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetDocumentSetResultBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetDocumentSetResultBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  		},
				new Object[]{
			 		routingToken,filter
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetDocumentSetResultBySiteNumberCommand' in method 'getDocumentSetResultBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCumulativeStatisticsDocumentSetResultForPatient(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCumulativeStatisticsDocumentSetResultCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics.class, 
	 				"GetCumulativeStatisticsDocumentSetResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,documentFilter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCumulativeStatisticsDocumentSetResultCommand' in method 'getCumulativeStatisticsDocumentSetResultForPatient' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getFullyLoadedPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetFullyLoadedArtifactResultsBySiteNumberDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetFullyLoadedArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetFullyLoadedArtifactResultsBySiteNumberDataSourceCommand' in method 'getFullyLoadedPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyOnlyPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyOnlyArtifactResultsBySiteNumberDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyOnlyArtifactResultsBySiteNumberDataSourceCommand' in method 'getStudyOnlyPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyOnlyPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetStudyOnlyArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetStudyOnlyArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudyOnlyArtifactResultsBySiteNumberCommand' in method 'getStudyOnlyPatientArtifactResultsFromSiteAsync' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithImagesPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetStudyWithImagesArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetStudyWithImagesArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudyWithImagesArtifactResultsBySiteNumberCommand' in method 'getStudyWithImagesPatientArtifactResultsFromSiteAsync' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithReportPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetStudyWithReportArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetStudyWithReportArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudyWithReportArtifactResultsBySiteNumberCommand' in method 'getStudyWithReportPatientArtifactResultsFromSiteAsync' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetFullyLoadedArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetFullyLoadedArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetFullyLoadedArtifactResultsBySiteNumberCommand' in method 'getPatientArtifactResultsFromSiteAsync' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithImagesPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyWithImagesArtifactResultsBySiteNumberDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithImagesArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyWithImagesArtifactResultsBySiteNumberDataSourceCommand' in method 'getStudyWithImagesPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithReportPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyWithReportArtifactResultsBySiteNumberDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithReportArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyWithReportArtifactResultsBySiteNumberDataSourceCommand' in method 'getStudyWithReportPatientArtifactResultsFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocument(
 			gov.va.med.GlobalArtifactIdentifier artifactIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentCommand' and parameters 'gov.va.med.GlobalArtifactIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class 
		  			},
 					new Object[]{
				 		artifactIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentCommand' in method 'getDocument' with parameters 'gov.va.med.GlobalArtifactIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchPatientStudies(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PrefetchPatientStudiesAsyncCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PrefetchPatientStudiesAsyncCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,studyLoadLevel
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PrefetchPatientStudiesAsyncCommand' in method 'prefetchPatientStudies' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceByImageUrnAsync(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetExamInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetExamInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetExamInstanceByImageUrnCommand' in method 'getExamInstanceByImageUrnAsync' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileByImageUrnAsync(
 			gov.va.med.imaging.ImageURN imageUrn
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'GetExamTextFileByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"GetExamTextFileByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class 
		  		},
				new Object[]{
			 		imageUrn
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'GetExamTextFileByImageUrnCommand' in method 'getExamTextFileByImageUrnAsync' with parameters 'gov.va.med.imaging.ImageURN'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchDocument(
 			gov.va.med.GlobalArtifactIdentifier gai
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PrefetchDocumentAsyncCommand' and parameters 'gov.va.med.GlobalArtifactIdentifier'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PrefetchDocumentAsyncCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.GlobalArtifactIdentifier.class 
		  		},
				new Object[]{
			 		gai
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PrefetchDocumentAsyncCommand' in method 'prefetchDocument' with parameters 'gov.va.med.GlobalArtifactIdentifier'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, java.lang.String annotationDetails
 		 			, java.lang.String annotationVersion
 		 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource annotationSource
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImageAnnotationDetailsDataSourceCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
	 				"PostImageAnnotationDetailsDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource.class 
		  			},
 					new Object[]{
				 		imagingUrn,annotationDetails,annotationVersion,annotationSource
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImageAnnotationDetailsDataSourceCommand' in method 'postImageAnnotationDetails' with parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImagingLogEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.ImagingLogEvent imagingLogEvent
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImagingLogEventDataSourceCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.ImagingLogEvent'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostImagingLogEventDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.ImagingLogEvent.class 
		  			},
 					new Object[]{
				 		routingToken,imagingLogEvent
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImagingLogEventDataSourceCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImagingLogEventRetryable(
 			gov.va.med.imaging.exchange.ImagingLogEvent imagingLogEvent
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostImagingLogEventRetryableCommand' and parameters 'gov.va.med.imaging.exchange.ImagingLogEvent'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostImagingLogEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImagingLogEvent.class 
		  		},
				new Object[]{
			 		imagingLogEvent
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostImagingLogEventRetryableCommand' in method 'postImagingLogEventRetryable' with parameters 'gov.va.med.imaging.exchange.ImagingLogEvent'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getMostRecentImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetMostRecentImageAnnotationDetailsCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class, 
	 				"GetMostRecentImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class 
		  			},
 					new Object[]{
				 		imagingUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetMostRecentImageAnnotationDetailsCommand' in method 'getMostRecentImageAnnotationDetails' with parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchInstanceByImageUrnSync(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PrefetchInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PrefetchInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList,imageMetadataNotification
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PrefetchInstanceByImageUrnCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientInformation(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientInformationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Patient.class, 
	 				"GetPatientInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientInformationCommand' in method 'getPatientInformation' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCumulativeStatisticsArtifactResultsForPatient(
 			gov.va.med.RoutingToken patientTreatingSiteRoutingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCumulativeStatisticsArtifactResultsForPatientCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics.class, 
	 				"GetCumulativeStatisticsArtifactResultsForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  			},
 					new Object[]{
				 		patientTreatingSiteRoutingToken,patientIdentifier,studyFilter,includeRadiology,includeDocuments,studyLoadLevel
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCumulativeStatisticsArtifactResultsForPatientCommand' in method 'getCumulativeStatisticsArtifactResultsForPatient' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean, gov.va.med.imaging.exchange.enums.StudyLoadLevel'.");
 		}

 }