/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.router.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class ImagingRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements ImagingRouter
 {
	private static ImagingRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized ImagingRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new ImagingRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected ImagingRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImageAccessEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostImageAccessEventFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  			},
 					new Object[]{
				 		routingToken,event
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostImageAccessEventFromDataSourceCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImageAccessEventRetryable(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostImageAccessEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  		},
				new Object[]{
			 		event
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PrefetchInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchInstanceByImageUrnDelayOneMinute(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PrefetchInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  		
			
			
			command.setPriority(1);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 60000) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamInstanceByImageUrnDelayOneMinute(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PrefetchExamInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  		
			
			
			command.setPriority(1);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 60000) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetListBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener<?> listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetDocumentSetListBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  		},
				new Object[]{
			 		routingToken,filter
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.Study> getStudyFromCprsIdentifier(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, gov.va.med.imaging.CprsIdentifier cprsIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudiesByCprsIdentifierFromDataSourceCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, gov.va.med.imaging.CprsIdentifier.class 
	  			},
				new Object[]{
			 		routingToken,patientIcn,cprsIdentifier
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetStudiesByCprsIdentifierFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.exchange.business.Study> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams getPatientEnterpriseExams(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, java.lang.Boolean fullyLoadExams
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams> command = (Command<gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams.class, 
	 				"GetPatientEnterpriseExamsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,fullyLoadExams
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientEnterpriseExamsCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.PatientRegistration getPatientRegistration(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.PatientRegistration> command = (Command<gov.va.med.imaging.exchange.business.vistarad.PatientRegistration>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.PatientRegistration.class, 
	 				"GetPatientRegistrationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientRegistrationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.vistarad.PatientRegistration commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String[] getRelevantPriorCptCodes(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String cptCode
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String[]> command = (Command<java.lang.String[]>)getCommandFactory().createCommand(
	 				 java.lang.String[].class, 
	 				"GetRelevantPriorCptCodesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,cptCode
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetRelevantPriorCptCodesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.String[] commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PrefetchExamImagesAsyncCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.StudyURN.class 
		  		},
				new Object[]{
			 		studyUrn
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"GetExamInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamInstanceByImageUrnCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class 
		  			},
 					new Object[]{
				 		imageUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileByImageUrnCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,imageMetadataNotification,outStream
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileByImageUrnCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getFullyLoadedExamSite(
 			gov.va.med.RoutingToken routingToken
 			, java.lang.String patientIcn
 			, boolean forceRefresh
 			, boolean forceImagesFromJb
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetFullyLoadedExamSiteBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getFullyLoadedExamSite(
 			gov.va.med.RoutingToken routingToken
 			, java.lang.String patientIcn
 			, boolean forceRefresh
 			, boolean forceImagesFromJb
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetFullyLoadedExamSiteBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamSiteBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, java.lang.String patientIcn
 			, java.lang.Boolean forceRefresh
 			, java.lang.Boolean forceImagesFromJb
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetExamSiteBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIcn,forceRefresh,forceImagesFromJb
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.storage.DataSourceInputStream getExamTextFileFromDataSource(
 			gov.va.med.imaging.ImageURN imageUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream> command = (Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetExamTextFileByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class 
		  			},
 					new Object[]{
				 		imageUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileByImageUrnFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.storage.DataSourceInputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.storage.DataSourceInputStream getExamTextFileFromDataSource(
 			gov.va.med.imaging.exchange.business.vistarad.ExamImage examImage
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream> command = (Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetExamTextFileByExamImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.vistarad.ExamImage.class 
		  			},
 					new Object[]{
				 		examImage
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileByExamImageFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.storage.DataSourceInputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ImageStreamResponse getExamInstanceFromDataSource(
 			gov.va.med.imaging.exchange.business.vistarad.ExamImage image
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQuality
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ImageStreamResponse> command = (Command<gov.va.med.imaging.exchange.business.ImageStreamResponse>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetExamInstanceByExamImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.vistarad.ExamImage.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		image,requestFormatQuality
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamInstanceByExamImageFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ImageStreamResponse commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ImageStreamResponse getExamInstanceFromDataSource(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQuality
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ImageStreamResponse> command = (Command<gov.va.med.imaging.exchange.business.ImageStreamResponse>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetExamInstanceByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,requestFormatQuality
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamInstanceByImageUrnFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ImageStreamResponse commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getExamReportFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetExamReportFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamReportFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getExamRequisitionReportFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetExamRequisitionReportFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamRequisitionReportFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.ExamListResult getExamsForPatientFromDataSource(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, boolean fullyLoadExams
 		 			, boolean forceRefresh
 		 			, boolean forceImagesFromJb
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.ExamListResult> command = (Command<gov.va.med.imaging.exchange.business.vistarad.ExamListResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamListResult.class, 
	 				"GetExamsForPatientFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, boolean.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,fullyLoadExams,forceRefresh,forceImagesFromJb
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamsForPatientFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.vistarad.ExamListResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.ExamImages getExamImagesForExamFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.ExamImages> command = (Command<gov.va.med.imaging.exchange.business.vistarad.ExamImages>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamImages.class, 
	 				"GetExamImagesForExamFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamImagesForExamFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.vistarad.ExamImages commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.Exam getExamFromDataSource(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.Exam> command = (Command<gov.va.med.imaging.exchange.business.vistarad.Exam>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.Exam.class, 
	 				"GetExamFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.vistarad.Exam commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentSetResult getPatientDocumentSets(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientIcn
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetPatientDocumentSetsDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIcn,filter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientDocumentSetsDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.documents.DocumentSetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ImageStreamResponse getDocumentFromDataSource(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ImageStreamResponse> command = (Command<gov.va.med.imaging.exchange.business.ImageStreamResponse>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetDocumentFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class 
		  			},
 					new Object[]{
				 		documentIdentifier
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ImageStreamResponse commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ImageStreamResponse getInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQualityList
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ImageStreamResponse> command = (Command<gov.va.med.imaging.exchange.business.ImageStreamResponse>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetInstanceByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,requestFormatQualityList
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetInstanceByImageUrnFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ImageStreamResponse commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ImageStreamResponse getInstanceByImage(
 			gov.va.med.imaging.exchange.business.Image image
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestFormatQualityList
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ImageStreamResponse> command = (Command<gov.va.med.imaging.exchange.business.ImageStreamResponse>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ImageStreamResponse.class, 
	 				"GetInstanceByImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.Image.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		image,requestFormatQualityList
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetInstanceByImageFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ImageStreamResponse commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.storage.DataSourceInputStream getInstanceTextFileByImage(
 			gov.va.med.imaging.exchange.business.Image image
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream> command = (Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetInstanceTextFileByImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.Image.class 
		  			},
 					new Object[]{
				 		image
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetInstanceTextFileByImageFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.storage.DataSourceInputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.storage.DataSourceInputStream getInstanceTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream> command = (Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"GetInstanceTextFileByImageUrnFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class 
		  			},
 					new Object[]{
				 		imageUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetInstanceTextFileByImageUrnFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.storage.DataSourceInputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyList(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetStudyListBySiteCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getStudySet(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetBySiteNumberFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,studyLoadLevel
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudySetBySiteNumberFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.io.InputStream getPatientIdentificationImage(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.io.InputStream> command = (Command<java.io.InputStream>)getCommandFactory().createCommand(
	 				 java.io.InputStream.class, 
	 				"GetPatientIdentificationImageFromDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientIdentificationImageFromDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.io.InputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultWithImagesBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetStudySetResultWithImagesBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultWithReportsBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetShallowStudySetWithReportBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getShallowStudySetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetShallowStudySetResultBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetStudySetResultBySiteCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics getCumulativeStatisticsStudySetResultForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics> command = (Command<gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics.class, 
	 				"GetCumulativeStatisticsStudySetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter,studyLoadLevel
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetCumulativeStatisticsStudySetResultForPatientCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetResultBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener<?> listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetDocumentSetResultBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  		},
				new Object[]{
			 		routingToken,filter
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics getCumulativeStatisticsDocumentSetResultForPatient(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics> command = (Command<gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics.class, 
	 				"GetCumulativeStatisticsDocumentSetResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,documentFilter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetCumulativeStatisticsDocumentSetResultCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ArtifactResults getFullyLoadedPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ArtifactResults> command = (Command<gov.va.med.imaging.exchange.business.ArtifactResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetFullyLoadedArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetFullyLoadedArtifactResultsBySiteNumberDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ArtifactResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ArtifactResults getStudyOnlyPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ArtifactResults> command = (Command<gov.va.med.imaging.exchange.business.ArtifactResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyOnlyArtifactResultsBySiteNumberDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ArtifactResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyOnlyPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetStudyOnlyArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithImagesPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetStudyWithImagesArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithReportPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetStudyWithReportArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientArtifactResultsFromSiteAsync(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, boolean includeRadiology
 			, boolean includeDocuments
 			, gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener listener
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetFullyLoadedArtifactResultsBySiteNumberCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  		}
		  	);
		  		
			command.addListener(listener);
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ArtifactResults getStudyWithImagesPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ArtifactResults> command = (Command<gov.va.med.imaging.exchange.business.ArtifactResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithImagesArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyWithImagesArtifactResultsBySiteNumberDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ArtifactResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ArtifactResults getStudyWithReportPatientArtifactResultsFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ArtifactResults> command = (Command<gov.va.med.imaging.exchange.business.ArtifactResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithReportArtifactResultsBySiteNumberDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyWithReportArtifactResultsBySiteNumberDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.ArtifactResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult getDocument(
 			gov.va.med.GlobalArtifactIdentifier artifactIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class 
		  			},
 					new Object[]{
				 		artifactIdentifier
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchPatientStudies(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PrefetchPatientStudiesAsyncCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,filter,studyLoadLevel
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceByImageUrnAsync(
 			gov.va.med.imaging.ImageURN imageUrn
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetExamInstanceByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		imageUrn,imageFormatQualityList
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileByImageUrnAsync(
 			gov.va.med.imaging.ImageURN imageUrn
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"GetExamTextFileByImageUrnCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.ImageURN.class 
		  		},
				new Object[]{
			 		imageUrn
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchDocument(
 			gov.va.med.GlobalArtifactIdentifier gai
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PrefetchDocumentAsyncCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.GlobalArtifactIdentifier.class 
		  		},
				new Object[]{
			 		gai
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.annotations.ImageAnnotation postImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, java.lang.String annotationDetails
 		 			, java.lang.String annotationVersion
 		 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource annotationSource
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.annotations.ImageAnnotation> command = (Command<gov.va.med.imaging.exchange.business.annotations.ImageAnnotation>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotation.class, 
	 				"PostImageAnnotationDetailsDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource.class 
		  			},
 					new Object[]{
				 		imagingUrn,annotationDetails,annotationVersion,annotationSource
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostImageAnnotationDetailsDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.annotations.ImageAnnotation commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImagingLogEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.ImagingLogEvent imagingLogEvent
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostImagingLogEventDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.ImagingLogEvent.class 
		  			},
 					new Object[]{
				 		routingToken,imagingLogEvent
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostImagingLogEventDataSourceCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postImagingLogEventRetryable(
 			gov.va.med.imaging.exchange.ImagingLogEvent imagingLogEvent
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostImagingLogEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImagingLogEvent.class 
		  		},
				new Object[]{
			 		imagingLogEvent
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails getMostRecentImageAnnotationDetails(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails> command = (Command<gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class, 
	 				"GetMostRecentImageAnnotationDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class 
		  			},
 					new Object[]{
				 		imagingUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetMostRecentImageAnnotationDetailsCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchInstanceByImageUrnSync(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PrefetchInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList,imageMetadataNotification
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PrefetchInstanceByImageUrnCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.Patient getPatientInformation(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.Patient> command = (Command<gov.va.med.imaging.exchange.business.Patient>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.Patient.class, 
	 				"GetPatientInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientInformationCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.Patient commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics getCumulativeStatisticsArtifactResultsForPatient(
 			gov.va.med.RoutingToken patientTreatingSiteRoutingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 			, gov.va.med.imaging.exchange.enums.StudyLoadLevel studyLoadLevel
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics> command = (Command<gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics.class, 
	 				"GetCumulativeStatisticsArtifactResultsForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class, gov.va.med.imaging.exchange.enums.StudyLoadLevel.class 
		  			},
 					new Object[]{
				 		patientTreatingSiteRoutingToken,patientIdentifier,studyFilter,includeRadiology,includeDocuments,studyLoadLevel
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetCumulativeStatisticsArtifactResultsForPatientCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.core.interfaces.router.CumulativeCommandStatistics commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }