/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: May 10, 2010
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.router.commands.annotations.datasource;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.datasource.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.imaging.core.router.AbstractDataSourceCommandImpl;
 import javax.annotation.Generated;
 
 @SuppressWarnings("unused")
 public class PostImageAnnotationDetailsDataSourceCommandImpl
 extends AbstractDataSourceCommandImpl<gov.va.med.imaging.exchange.business.annotations.ImageAnnotation,ImageAnnotationDataSourceSpi>
 {
 	private final static long serialVersionUID = 1L;
 
 	private final gov.va.med.imaging.AbstractImagingURN imagingUrn;
 	private final java.lang.String annotationDetails;
 	private final java.lang.String annotationVersion;
 	private final gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource annotationSource;
 
 	public PostImageAnnotationDetailsDataSourceCommandImpl(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, java.lang.String annotationDetails
 		 			, java.lang.String annotationVersion
 		 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource annotationSource
 		)
 	{
	 	this.imagingUrn = imagingUrn;	 	
	 	this.annotationDetails = annotationDetails;	 	
	 	this.annotationVersion = annotationVersion;	 	
	 	this.annotationSource = annotationSource;	 	
 	}
 	
 	@Override
	protected gov.va.med.imaging.exchange.business.annotations.ImageAnnotation getCommandResult(ImageAnnotationDataSourceSpi spi)
	throws ConnectionException, MethodException
	{
			return spi.storeImageAnnotationDetails(
		 			imagingUrn
		 				 			, annotationDetails
		 				 			, annotationVersion
		 				 			, annotationSource
		 		);
	}
	
	@Override
	public gov.va.med.RoutingToken getRoutingToken()
	{
		return imagingUrn;	
	}

	@Override
	protected String getSiteNumber()
	{
		return getRoutingToken().getRepositoryUniqueId();
	}

	@Override
	protected Class<ImageAnnotationDataSourceSpi> getSpiClass()
	{
		return ImageAnnotationDataSourceSpi.class;
	}
 
 	@Override
	protected String getSpiMethodName()
	{
		return "storeImageAnnotationDetails";
	}
	
	@Override
	protected Class<?>[] getSpiMethodParameterTypes()
	{			
		return new Class<?> [] {
	 			gov.va.med.imaging.AbstractImagingURN.class
	 			, java.lang.String.class
	 			, java.lang.String.class
	 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource.class
	 	};
	}
	
	@Override
	protected Object[] getSpiMethodParameters()
	{
		return new Object [] {
	 			imagingUrn
	 			, annotationDetails
	 			, annotationVersion
	 			, annotationSource
	 	};	
	}
	
	@Override
	protected gov.va.med.imaging.exchange.business.annotations.ImageAnnotation postProcessResult(gov.va.med.imaging.exchange.business.annotations.ImageAnnotation result)
	{
		return result;
	}
 }
