/**
 * 
 */
package gov.va.med.imaging.proxy;

import gov.va.med.imaging.Equivalence;

/**
 * @author     DNS
 * 
 * The generic superclass of synchronous proxy results.
 * Currently this class is mostly a placeholder for common result fields,
 * of which there is exactly one.  I would expect that to increase as error 
 * handling becomes more rigorous.
 * 
 * The correlation ID is either generated by the proxy or is copied by the proxy
 * from the request object.
 */
public abstract class AbstractResult
implements java.io.Serializable, Equivalence
{
	private final String transactionId;
	
	public AbstractResult(String transactionId)
	{
		super();
		this.transactionId = transactionId;
	}

	/**
	 * @return the transactionId
	 */
	public String getTransactionId()
	{
		return this.transactionId;
	}

	/**
	 * Compares the content of the results for equivalence, where all fields
	 * except the primary key must be equal.
	 * 
	 * @param obj
	 * @return
	 */
	public abstract boolean equivalent(Object obj);
}
