/*
 * Created on Oct 28, 2005
 *
 */
package gov.va.med.imaging.dicom.test;

import gov.va.med.imaging.dicom.common.Constants;
import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.dcftoolkit.common.impl.DicomDataSetImpl;
import gov.va.med.imaging.dicom.scp.exceptions.UnsupportedLevelException;
import gov.va.med.imaging.dicom.scp.exceptions.QRFactoryTranslationException;
import gov.va.med.imaging.dicom.scp.qrfactory.factory.QueryRootFactory;
import gov.va.med.imaging.exchange.business.dicom.DicomMap;
import gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters;

import java.util.HashSet;

import com.lbs.DCS.AttributeTag;
import com.lbs.DCS.DCSException;
import com.lbs.DCS.DicomDataSet;

/**
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * @author William Peterson
 *
 */
public class QueryFactoryTest extends DicomBase {

    /**
     * Constructor
     *
     * @param arg0
     */
    public QueryFactoryTest(String arg0) {
        super(arg0);
    }

    
    protected void setUp()throws Exception{
    	super.setUp();
    }
    
    protected void tearDown() throws Exception{
    	super.tearDown();
    }
    
    public void testCFindOne(){
        DicomDataSet dds = new DicomDataSet();
        
        try{
        	AttributeTag sopClass = new AttributeTag("0008,0016");
        	dds.insert(sopClass, Constants.STUDYROOT_FIND);
            AttributeTag StudyDate = new AttributeTag("0008,0020");
            dds.insert(StudyDate, "");
            AttributeTag StudyTime = new AttributeTag("0008,0030");
            dds.insert(StudyTime, "");
            AttributeTag Accession = new AttributeTag("0008,0050");
            dds.insert(Accession, "022102-105");
            AttributeTag QueryLevel = new AttributeTag("0008,0052");
            dds.insert(QueryLevel, "STUDY");
            AttributeTag InstanceAvail = new AttributeTag("0008,0056");
            dds.insert(InstanceAvail, "");
            AttributeTag Modalities = new AttributeTag("0008,0061");
            dds.insert(Modalities, "");
            AttributeTag Institution = new AttributeTag("0008,0080");
            dds.insert(Institution, "");
            AttributeTag ReferringPhysician = new AttributeTag("0008,0090");
            dds.insert(ReferringPhysician, "");
            AttributeTag StudyDescription = new AttributeTag("0008,1030");
            dds.insert(StudyDescription, "");
            AttributeTag Department = new AttributeTag("0008,1040");
            dds.insert(Department, "");
            AttributeTag PatientName = new AttributeTag("0010,0010");
            dds.insert(PatientName, "");
            AttributeTag PatientID = new AttributeTag("0010,0020");
            dds.insert(PatientID, "");
            AttributeTag BirthDate = new AttributeTag("0010,0030");
            dds.insert(BirthDate, "");
            AttributeTag Sex = new AttributeTag("0010,0040");
            dds.insert(Sex, "");
            AttributeTag StudyInstanceUID = new AttributeTag("0020,000d");
            dds.insert(StudyInstanceUID, "");
            AttributeTag StudyID = new AttributeTag("0020,0010");
            dds.insert(StudyID, "");
                       
            DicomRequestParameters queryResponse = CFindToHashMap(dds);            
            if(queryResponse == null){
            	fail();
            }
            if(queryResponse.isEmpty()){
            	fail();
            }
            TESTLOGGER.info("\nHashMap: " + queryResponse.toString());
        }
        catch(UnsupportedLevelException iddsX){
        	iddsX.printStackTrace();
        	fail();
        }
        catch(QRFactoryTranslationException ptX){
            fail();
        }
        catch(DCSException dcsX){
        	TESTLOGGER.error("\nCould not build DICOM Dataset.");
        }
    }

    public void testCFindTwo(){
        DicomDataSet dds = new DicomDataSet();
        
        try{
        	AttributeTag sopClass = new AttributeTag("0008,0016");
        	dds.insert(sopClass, Constants.STUDYROOT_FIND);
            AttributeTag StudyDate = new AttributeTag("0008,0020");
            dds.insert(StudyDate, "");
            AttributeTag StudyTime = new AttributeTag("0008,0030");
            dds.insert(StudyTime, "");
            AttributeTag Accession = new AttributeTag("0008,0050");
            dds.insert(Accession, "050207-1867");
            AttributeTag QueryLevel = new AttributeTag("0008,0052");
            dds.insert(QueryLevel, "STUDY");
            AttributeTag Modalities = new AttributeTag("0008,0061");
            dds.insert(Modalities, "");
            AttributeTag ReferringPhysician = new AttributeTag("0008,0090");
            dds.insert(ReferringPhysician, "");
            AttributeTag StudyDescription = new AttributeTag("0008,1030");
            dds.insert(StudyDescription, "");
            AttributeTag AdmittingDiagnosisDescription = new AttributeTag("0008,1080");
            dds.insert(AdmittingDiagnosisDescription, "");
            AttributeTag PatientName = new AttributeTag("0010,0010");
            dds.insert(PatientName, "FRED, FDFD");
            AttributeTag PatientID = new AttributeTag("0010,0020");
            dds.insert(PatientID, "");
            AttributeTag BirthDate = new AttributeTag("0010,0030");
            dds.insert(BirthDate, "");
            AttributeTag BirthTime = new AttributeTag("0010,0032");
            dds.insert(BirthTime, "");
            AttributeTag Sex = new AttributeTag("0010,0040");
            dds.insert(Sex, "");
            AttributeTag weight = new AttributeTag("0010,1030");
            dds.insert(weight, "");
            AttributeTag ethnic = new AttributeTag("0010,2160");
            dds.insert(ethnic, "");
            AttributeTag occupation = new AttributeTag("0010,2180");
            dds.insert(occupation, "");
            AttributeTag additionalPatientHistory = new AttributeTag("0010,21b0");
            dds.insert(additionalPatientHistory, "");
            AttributeTag patientComments = new AttributeTag("0010,4000");
            dds.insert(patientComments, "");
            AttributeTag StudyInstanceUID = new AttributeTag("0020,000d");
            dds.insert(StudyInstanceUID, "");
            AttributeTag StudyID = new AttributeTag("0020,0010");
            dds.insert(StudyID, "");
            AttributeTag otherStudyNumbers = new AttributeTag("0020,1070");
            dds.insert(otherStudyNumbers, "");
            AttributeTag numberofRelatedSeries = new AttributeTag("0020,1206");
            dds.insert(numberofRelatedSeries, "");
            AttributeTag numberofRelatedInstances = new AttributeTag("0020,1208");
            dds.insert(numberofRelatedInstances, "");
            
            DicomRequestParameters queryResponse = CFindToHashMap(dds);   
            if(queryResponse == null){
            	fail();
            }
            if(queryResponse.isEmpty()){
            	fail();
            }            
            TESTLOGGER.info("\nHashMap: " + queryResponse.toString());
        }
        catch(UnsupportedLevelException iddsX){
        	fail();
        }
        catch(QRFactoryTranslationException ptX){
            fail();
        }
        catch(DCSException dcsX){
        	TESTLOGGER.error("\nCould not build DICOM Dataset.");
        }
    }

    public void testCFindThree(){
        DicomDataSet dds = new DicomDataSet();
        
        try{
        	AttributeTag sopClass = new AttributeTag("0008,0016");
        	dds.insert(sopClass, Constants.STUDYROOT_FIND);
            AttributeTag StudyDate = new AttributeTag("0008,0020");
            dds.insert(StudyDate, "");
            AttributeTag StudyTime = new AttributeTag("0008,0030");
            dds.insert(StudyTime, "");
            AttributeTag Accession = new AttributeTag("0008,0050");
            dds.insert(Accession, "050207-1867");
            AttributeTag QueryLevel = new AttributeTag("0008,0052");
            dds.insert(QueryLevel, "PATIENT");
            AttributeTag Modalities = new AttributeTag("0008,0061");
            dds.insert(Modalities, "");
            AttributeTag ReferringPhysician = new AttributeTag("0008,0090");
            dds.insert(ReferringPhysician, "");
            AttributeTag StudyDescription = new AttributeTag("0008,1030");
            dds.insert(StudyDescription, "");
            AttributeTag AdmittingDiagnosisDescription = new AttributeTag("0008,1080");
            dds.insert(AdmittingDiagnosisDescription, "");
            AttributeTag PatientName = new AttributeTag("0010,0010");
            dds.insert(PatientName, "FRED, FDFD");
            AttributeTag PatientID = new AttributeTag("0010,0020");
            dds.insert(PatientID, "");
            AttributeTag BirthDate = new AttributeTag("0010,0030");
            dds.insert(BirthDate, "");
            AttributeTag BirthTime = new AttributeTag("0010,0032");
            dds.insert(BirthTime, "");
            AttributeTag Sex = new AttributeTag("0010,0040");
            dds.insert(Sex, "");
            AttributeTag weight = new AttributeTag("0010,1030");
            dds.insert(weight, "");
            AttributeTag ethnic = new AttributeTag("0010,2160");
            dds.insert(ethnic, "");
            AttributeTag occupation = new AttributeTag("0010,2180");
            dds.insert(occupation, "");
            AttributeTag additionalPatientHistory = new AttributeTag("0010,21b0");
            dds.insert(additionalPatientHistory, "");
            AttributeTag patientComments = new AttributeTag("0010,4000");
            dds.insert(patientComments, "");
            AttributeTag StudyInstanceUID = new AttributeTag("0020,000d");
            dds.insert(StudyInstanceUID, "");
            AttributeTag StudyID = new AttributeTag("0020,0010");
            dds.insert(StudyID, "");
            AttributeTag otherStudyNumbers = new AttributeTag("0020,1070");
            dds.insert(otherStudyNumbers, "");
            AttributeTag numberofRelatedSeries = new AttributeTag("0020,1206");
            dds.insert(numberofRelatedSeries, "");
            AttributeTag numberofRelatedInstances = new AttributeTag("0020,1208");
            dds.insert(numberofRelatedInstances, "");
            
            DicomRequestParameters queryResponse = CFindToHashMap(dds);
            fail();
        }
        catch(UnsupportedLevelException iddsX){
        	TESTLOGGER.info("Exception thrown as expected.");
        }
        catch(QRFactoryTranslationException ptX){
            fail();
        }
        catch(DCSException dcsX){
        	TESTLOGGER.error("\nCould not build DICOM Dataset.");
        }
    }

    
    public void testCFindFour(){
        DicomDataSet dds = new DicomDataSet();
        
        try{
        	AttributeTag sopClass = new AttributeTag("0008,0016");
        	dds.insert(sopClass, Constants.STUDYROOT_FIND);
            AttributeTag StudyDate = new AttributeTag("0008,0020");
            dds.insert(StudyDate, "");
            AttributeTag StudyTime = new AttributeTag("0008,0030");
            dds.insert(StudyTime, "");
            AttributeTag Accession = new AttributeTag("0008,0050");
            dds.insert(Accession, "050207-1867");
            AttributeTag QueryLevel = new AttributeTag("0008,0052");
            dds.insert(QueryLevel, "SERIES");
            AttributeTag Modalities = new AttributeTag("0008,0061");
            dds.insert(Modalities, "");
            AttributeTag ReferringPhysician = new AttributeTag("0008,0090");
            dds.insert(ReferringPhysician, "");
            AttributeTag StudyDescription = new AttributeTag("0008,1030");
            dds.insert(StudyDescription, "");
            AttributeTag AdmittingDiagnosisDescription = new AttributeTag("0008,1080");
            dds.insert(AdmittingDiagnosisDescription, "");
            AttributeTag PatientName = new AttributeTag("0010,0010");
            dds.insert(PatientName, "FRED, FDFD");
            AttributeTag PatientID = new AttributeTag("0010,0020");
            dds.insert(PatientID, "");
            AttributeTag BirthDate = new AttributeTag("0010,0030");
            dds.insert(BirthDate, "");
            AttributeTag BirthTime = new AttributeTag("0010,0032");
            dds.insert(BirthTime, "");
            AttributeTag Sex = new AttributeTag("0010,0040");
            dds.insert(Sex, "");
            AttributeTag weight = new AttributeTag("0010,1030");
            dds.insert(weight, "");
            AttributeTag ethnic = new AttributeTag("0010,2160");
            dds.insert(ethnic, "");
            AttributeTag occupation = new AttributeTag("0010,2180");
            dds.insert(occupation, "");
            AttributeTag additionalPatientHistory = new AttributeTag("0010,21b0");
            dds.insert(additionalPatientHistory, "");
            AttributeTag patientComments = new AttributeTag("0010,4000");
            dds.insert(patientComments, "");
            AttributeTag StudyInstanceUID = new AttributeTag("0020,000d");
            dds.insert(StudyInstanceUID, "");
            AttributeTag StudyID = new AttributeTag("0020,0010");
            dds.insert(StudyID, "");
            AttributeTag otherStudyNumbers = new AttributeTag("0020,1070");
            dds.insert(otherStudyNumbers, "");
            AttributeTag numberofRelatedSeries = new AttributeTag("0020,1206");
            dds.insert(numberofRelatedSeries, "");
            AttributeTag numberofRelatedInstances = new AttributeTag("0020,1208");
            dds.insert(numberofRelatedInstances, "");
            
            DicomRequestParameters queryResponse = CFindToHashMap(dds);
            fail();
        }
        catch(UnsupportedLevelException iddsX){
        	TESTLOGGER.info("Exception thrown as expected.");
        }
        catch(QRFactoryTranslationException ptX){
            fail();
        }
        catch(DCSException dcsX){
        	TESTLOGGER.fatal("\nCould not build DICOM Dataset.");
        }
    }

    private DicomRequestParameters CFindToHashMap(DicomDataSet dds)throws UnsupportedLevelException, QRFactoryTranslationException{
        IDicomDataSet encapDDS = new DicomDataSetImpl(dds);
    
        QueryRootFactory factory = new QueryRootFactory();
        DicomRequestParameters queryResponse = factory.createQueryRequestParameters(encapDDS);
        
        return queryResponse;
                    
    }

}
