/*
 * Created on Aug 1, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 */
package gov.va.med.imaging.dicom.scp.qrfactory.products;

import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.scp.exceptions.QRFactoryTranslationException;
import gov.va.med.imaging.dicom.scp.exceptions.UnsupportedLevelException;
import gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters;


/**
 *
 * Abstract class for various subclasses representing the different Q/R SOP Class
 * Presentation Contexts.  This represents the product definition of the 
 * MethodFactory pattern.
 *
 * @author William Peterson
 *
 */
abstract public class QueryRoot {

    /**
     * Called when receiving a C-Find-Rq Dimse message.
     * 
     * Creates Hashmap object based on received DicomDataSet object.  The Hashmap 
     * object is necessary to pass to the Business layer.  The data in the 
     * DicomDataSet is basically converted to the Hashmap.  Then the Hashmap 
     * contains the same data as the DicomDataSet.
     * 
     * 
     * @param dds represents the DicomDataSet received in the C-Find-Rq Dimse message
     * @return
     * @throws QRFactoryTranslationException
     * @throws UnsupportedLevelException
     */
    public abstract DicomRequestParameters createQueryParameters(IDicomDataSet dds)
            throws QRFactoryTranslationException, UnsupportedLevelException;

    /**
     * Called when receiving a C-Move-Rq Dimse message.
     * 
     * Create Hashmap object based on received DicomDataSet object.  The Hashmap 
     * object is necessary to pass to the Business layer.  The data in the 
     * DicomDataSet is basically converted to the Hashmap.  Then the Hashmap
     * contains the same data as the DicomDataSet.
     * 
     * @param dds represents the DicomDataSet
     * @return
     * @throws QRFactoryTranslationException
     * @throws UnsupportedLevelException
     */
    public abstract DicomRequestParameters createMoveParameters(IDicomDataSet dds)
            throws QRFactoryTranslationException, UnsupportedLevelException;

}
