/*
 * Created on Aug 15, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 */
package gov.va.med.imaging.dicom.scp.movescp.interfaces;

// import gov.va.med.imaging.GUID;
import gov.va.med.imaging.core.interfaces.exceptions.InvalidUserCredentialsException;
import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.scp.exceptions.GenericDicomSCPException;
import gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver;

import java.util.Observer;

/**
 *
 * Interface.  This Interface is specific to Move SCP Service.  The implementation of this
 * Interface receives a request to move DICOM Objects to a C-Store SCP.  This Interface 
 * converts the received DicomDataSet into a HashMap via the QueryRootFactory. This 
 * Interface exist at the Generic Dicom Layer.  Thus, its primary function is to prepare
 * data to be sent to the Business Layer.  This includes removing any Dicom specific
 * formatting/information. The DicomDataSet shall be Toolkit independent at this time.
 *
 *
 * @author William Peterson
 *
 */
public interface IMoveSCPControl {

    /**
     * Handles the request to move items(DICOM objects) to a C-Store SCP.  Does not 
     * actually perform the C-Store activity.  
     * 
     * @param storeAETitle represents the AETitle of the C-Store SCP.
     * @param dds represents the DicomDataSet object.
     * @param subOperationsSubscriber represents the Subscriber of the Observer pattern.
     * @return represents all relating jobs/tasks for the C-Store activity.  This is for
     * future use in case of a C-Cancel.
     * @throws GenericDicomSCPException
     * @throws InvalidUserCredentialsException 
     */
    public MoveCommandObserver moveItems(String storeAETitle, IDicomDataSet dds,
            Observer subOperationsSubscriber) throws GenericDicomSCPException, InvalidUserCredentialsException;
    
}
