/*
 * Created on Aug 1, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 * 
 */
package gov.va.med.imaging.dicom.scp.findscp.interfaces;

import gov.va.med.imaging.core.interfaces.exceptions.InvalidUserCredentialsException;
import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback;
import gov.va.med.imaging.dicom.scp.exceptions.GenericDicomSCPException;
import gov.va.med.imaging.exchange.business.dicom.CFindResults;
import gov.va.med.imaging.exchange.business.dicom.DicomAE;

/**
 *
 * Interface.  This Interface is specific to Find SCP Service.  This Interface receives
 * a request to match Items in a DicomDataSet object.  Upon receiving the result, a RowSet
 * object is returned to the caller.  This Interface also acts a RowSet converter.  For
 * each row in the RowSet object, it shall convert that row into a DicomDataSet.
 * This Interface exist at the Generic Dicom Layer.  The DicomDataSet shall be Toolkit
 * independent at this time.
 *
 *
 * @author William Peterson
 *
 */
public interface IFindSCPControl {

    /**
     * Handles request to match Items in the DicomDataSet object.  It also receives 
     * the Root and Level of the Query requested.  This is necessary to determine the
     * proper result.  This is dictated by the DICOM Standard. A RowSet object is returned.
     * The RowSet object contains all responses given by the Business Layer.  According
     * to the DICOM Standard, the RowSet object must be iterated through and each row is
     * a separate response to the C-Find SCU.
     * 
     * @param dicomDataSet represents the Items for the C-Find Request.
     * @return a RowSet containing all responses to the request.
     * @throws GenericDicomSCPException
     * @throws InvalidUserCredentialsException 
     */
    public CFindResults requestMatchingItems(IDicomDataSet dicomDataSet) 
    			throws GenericDicomSCPException, InvalidUserCredentialsException;
    
    
    public void sendCFindResults(CFindResults resultSet, DicomAE dicomAE, 
    				IFindSCPResponseCallback callback) 
    				throws GenericDicomSCPException, InvalidUserCredentialsException;
    
}

