/*
 * Created on Nov 18, 2005
 *
 */
package gov.va.med.imaging.core.router.commands;

import java.io.IOException;

import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.notifications.email.NotificationEmailConfiguration;
import junit.framework.TestCase;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/**
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * @author William Peterson
 *
 */
public class ImagingDicomRouterTestBase extends TestCase {
  
    public static Logger logger = LogManager.getRootLogger();
    public static ConsoleAppender appender;


    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        appender = new ConsoleAppender(new PatternLayout());
        logger.addAppender(appender);
        logger.setLevel(Level.DEBUG);
		DicomServerConfiguration.getConfiguration().setSiteId("660");
		DicomServerConfiguration.getConfiguration().setHostName("test");
		NotificationEmailConfiguration.getConfiguration().setMaximumMessageCountPerEmail(20);
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
        logger.removeAllAppenders();
        LogManager.shutdown();
    }

    /**
     * Constructor for DicomDCFSCUTestBase.
     * @param arg0
     */
    public ImagingDicomRouterTestBase(String arg0) {
        super(arg0);
    }
}
