/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       BECKEC
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.dicom.router.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class InternalDicomRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public InternalDicomRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudyLookupResults(
 			gov.va.med.imaging.exchange.business.dicom.PatientStudyInfo patientStudyInfo
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientStudyLookupResultsCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.PatientStudyInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults.class, 
	 				"GetPatientStudyLookupResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientStudyInfo.class 
		  			},
 					new Object[]{
				 		patientStudyInfo
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientStudyLookupResultsCommand' in method 'getPatientStudyLookupResults' with parameters 'gov.va.med.imaging.exchange.business.dicom.PatientStudyInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyUIDCheckResult(
 			gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo uidCheckInfo
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyUIDCheckResultCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.UIDCheckResult.class, 
	 				"GetStudyUIDCheckResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo.class 
		  			},
 					new Object[]{
				 		uidCheckInfo
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyUIDCheckResultCommand' in method 'getStudyUIDCheckResult' with parameters 'gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getSeriesUIDCheckResult(
 			gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo uidCheckInfo
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetSeriesUIDCheckResultCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.UIDCheckResult.class, 
	 				"GetSeriesUIDCheckResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo.class 
		  			},
 					new Object[]{
				 		uidCheckInfo
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetSeriesUIDCheckResultCommand' in method 'getSeriesUIDCheckResult' with parameters 'gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getSOPInstanceUIDCheckResult(
 			gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo uidCheckInfo
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetSOPInstanceUIDCheckResultCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.UIDCheckResult.class, 
	 				"GetSOPInstanceUIDCheckResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo.class 
		  			},
 					new Object[]{
				 		uidCheckInfo
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetSOPInstanceUIDCheckResultCommand' in method 'getSOPInstanceUIDCheckResult' with parameters 'gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDicomUid(
 			java.lang.String accessionNumber
 		 			, java.lang.String siteId
 		 			, java.lang.String instrument
 		 			, java.lang.String type
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDicomUidCommand' and parameters 'java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomUid.class, 
	 				"GetDicomUidCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		accessionNumber,siteId,instrument,type
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDicomUidCommand' in method 'getDicomUid' with parameters 'java.lang.String, java.lang.String, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomCorrect(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults patientStudyLookupResults
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, boolean isNetworkImport
 		 			, java.lang.String originIndex
 		 			, java.io.InputStream inputStream
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDicomCorrectCommand' and parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, boolean, java.lang.String, java.io.InputStream'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostDicomCorrectCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, boolean.class, java.lang.String.class, java.io.InputStream.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,patientStudyLookupResults,instrument,isNetworkImport,originIndex,inputStream
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDicomCorrectCommand' in method 'postDicomCorrect' with parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, boolean, java.lang.String, java.io.InputStream'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomInstanceTo2005(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, java.nio.channels.ReadableByteChannel instanceChannel
 		 			, java.io.InputStream inputStream
 		 			, java.lang.String originIndex
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDicomInstanceTo2005Command' and parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, java.nio.channels.ReadableByteChannel, java.io.InputStream, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostDicomInstanceTo2005Command",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, java.nio.channels.ReadableByteChannel.class, java.io.InputStream.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,instrument,instanceChannel,inputStream,originIndex
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDicomInstanceTo2005Command' in method 'postDicomInstanceTo2005' with parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, java.nio.channels.ReadableByteChannel, java.io.InputStream, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomInstanceToNewStructure(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults patientStudyLookupResults
 		 			, gov.va.med.imaging.exchange.business.dicom.UIDCheckResults uidCheckResults
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, int iodValidationStatus
 		 			, java.nio.channels.ReadableByteChannel instanceChannel
 		 			, java.io.InputStream inputStream
 		 			, java.lang.String originIndex
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDicomInstanceToNewStructureCommand' and parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults, gov.va.med.imaging.exchange.business.dicom.UIDCheckResults, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, int, java.nio.channels.ReadableByteChannel, java.io.InputStream, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostDicomInstanceToNewStructureCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults.class, gov.va.med.imaging.exchange.business.dicom.UIDCheckResults.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, int.class, java.nio.channels.ReadableByteChannel.class, java.io.InputStream.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,patientStudyLookupResults,uidCheckResults,instrument,iodValidationStatus,instanceChannel,inputStream,originIndex
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDicomInstanceToNewStructureCommand' in method 'postDicomInstanceToNewStructure' with parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults, gov.va.med.imaging.exchange.business.dicom.UIDCheckResults, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, int, java.nio.channels.ReadableByteChannel, java.io.InputStream, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postStoreCommitWorkItem(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem scWI
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostStoreCommitWorkItemCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, 
	 				"PostStoreCommitWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class 
		  			},
 					new Object[]{
				 		scWI
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostStoreCommitWorkItemCommand' in method 'postStoreCommitWorkItem' with parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStoreCommitWorkItemList(
 			gov.va.med.imaging.exchange.business.dicom.SCWorkItemQueryParameters parameters
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStoreCommitWorkItemListCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.SCWorkItemQueryParameters'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, 
 				"GetStoreCommitWorkItemListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.dicom.SCWorkItemQueryParameters.class 
	  			},
				new Object[]{
			 		parameters
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetStoreCommitWorkItemListCommand' in method 'getStoreCommitWorkItemList' with parameters 'gov.va.med.imaging.exchange.business.dicom.SCWorkItemQueryParameters'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStoreCommitWorkItem(
 			java.lang.String scWIID
 		 			, java.lang.Boolean doProcess
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStoreCommitWorkItemCommand' and parameters 'java.lang.String, java.lang.Boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, 
	 				"GetStoreCommitWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		scWIID,doProcess
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStoreCommitWorkItemCommand' in method 'getStoreCommitWorkItem' with parameters 'java.lang.String, java.lang.Boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postStoreCommitWorkItemStatus(
 			java.lang.String scWIID
 		 			, java.lang.String status
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostStoreCommitWorkItemStatusCommand' and parameters 'java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostStoreCommitWorkItemStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		scWIID,status
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostStoreCommitWorkItemStatusCommand' in method 'postStoreCommitWorkItemStatus' with parameters 'java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDeleteStoreCommitWorkItem(
 			java.lang.String scWIID
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDeleteStoreCommitWorkItemCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostDeleteStoreCommitWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		scWIID
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDeleteStoreCommitWorkItemCommand' in method 'postDeleteStoreCommitWorkItem' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postSendSCResponse(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem scWI
 		 			, gov.va.med.imaging.core.router.commands.StorageCommitWaiter scWaiter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostSendSCResponseCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem, gov.va.med.imaging.core.router.commands.StorageCommitWaiter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"PostSendSCResponseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, gov.va.med.imaging.core.router.commands.StorageCommitWaiter.class 
		  			},
 					new Object[]{
				 		scWI,scWaiter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostSendSCResponseCommand' in method 'postSendSCResponse' with parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem, gov.va.med.imaging.core.router.commands.StorageCommitWaiter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomInstance(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, gov.va.med.imaging.dicom.common.DicomFileMetaInfo metaData
 		 			, int iodValidationStatus
 		 			, boolean isAlreadyReconciled
 		 			, java.lang.String originIndex
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDicomInstanceCommand' and parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, gov.va.med.imaging.dicom.common.DicomFileMetaInfo, int, boolean, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomStorageResults.class, 
	 				"PostDicomInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, gov.va.med.imaging.dicom.common.DicomFileMetaInfo.class, int.class, boolean.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,instrument,metaData,iodValidationStatus,isAlreadyReconciled,originIndex
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDicomInstanceCommand' in method 'postDicomInstance' with parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, gov.va.med.imaging.dicom.common.DicomFileMetaInfo, int, boolean, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getOrCreatePatientRef(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patientRef
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetOrCreatePatientRefCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.PatientRef'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, 
	 				"GetOrCreatePatientRefCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class 
		  			},
 					new Object[]{
				 		patientRef
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetOrCreatePatientRefCommand' in method 'getOrCreatePatientRef' with parameters 'gov.va.med.imaging.exchange.business.dicom.PatientRef'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getOrCreateProcedureRef(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patientRef
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedureRef
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetOrCreateProcedureRefCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.PatientRef, gov.va.med.imaging.exchange.business.dicom.ProcedureRef'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, 
	 				"GetOrCreateProcedureRefCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class 
		  			},
 					new Object[]{
				 		patientRef,procedureRef
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetOrCreateProcedureRefCommand' in method 'getOrCreateProcedureRef' with parameters 'gov.va.med.imaging.exchange.business.dicom.PatientRef, gov.va.med.imaging.exchange.business.dicom.ProcedureRef'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getOrCreateStudy(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patientRef
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedureRef
 		 			, gov.va.med.imaging.exchange.business.dicom.Study study
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetOrCreateStudyCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.PatientRef, gov.va.med.imaging.exchange.business.dicom.ProcedureRef, gov.va.med.imaging.exchange.business.dicom.Study'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.Study.class, 
	 				"GetOrCreateStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, gov.va.med.imaging.exchange.business.dicom.Study.class 
		  			},
 					new Object[]{
				 		patientRef,procedureRef,study
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetOrCreateStudyCommand' in method 'getOrCreateStudy' with parameters 'gov.va.med.imaging.exchange.business.dicom.PatientRef, gov.va.med.imaging.exchange.business.dicom.ProcedureRef, gov.va.med.imaging.exchange.business.dicom.Study'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getOrCreateSeries(
 			gov.va.med.imaging.exchange.business.dicom.Study study
 		 			, gov.va.med.imaging.exchange.business.dicom.Series series
 		 			, java.lang.Integer iodValidationStatus
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetOrCreateSeriesCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.Study, gov.va.med.imaging.exchange.business.dicom.Series, java.lang.Integer'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.Series.class, 
	 				"GetOrCreateSeriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.Study.class, gov.va.med.imaging.exchange.business.dicom.Series.class, java.lang.Integer.class 
		  			},
 					new Object[]{
				 		study,series,iodValidationStatus
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetOrCreateSeriesCommand' in method 'getOrCreateSeries' with parameters 'gov.va.med.imaging.exchange.business.dicom.Study, gov.va.med.imaging.exchange.business.dicom.Series, java.lang.Integer'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postSOPInstance(
 			gov.va.med.imaging.exchange.business.dicom.Series series
 		 			, gov.va.med.imaging.exchange.business.dicom.SOPInstance sopInstance
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostSOPInstanceCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.Series, gov.va.med.imaging.exchange.business.dicom.SOPInstance'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.SOPInstance.class, 
	 				"PostSOPInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.Series.class, gov.va.med.imaging.exchange.business.dicom.SOPInstance.class 
		  			},
 					new Object[]{
				 		series,sopInstance
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostSOPInstanceCommand' in method 'postSOPInstance' with parameters 'gov.va.med.imaging.exchange.business.dicom.Series, gov.va.med.imaging.exchange.business.dicom.SOPInstance'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postInstanceFile(
 			gov.va.med.imaging.exchange.business.dicom.SOPInstance sopInstance
 		 			, gov.va.med.imaging.exchange.business.dicom.InstanceFile instanceFile
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostInstanceFileCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.SOPInstance, gov.va.med.imaging.exchange.business.dicom.InstanceFile'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.InstanceFile.class, 
	 				"PostInstanceFileCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.SOPInstance.class, gov.va.med.imaging.exchange.business.dicom.InstanceFile.class 
		  			},
 					new Object[]{
				 		sopInstance,instanceFile
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostInstanceFileCommand' in method 'postInstanceFile' with parameters 'gov.va.med.imaging.exchange.business.dicom.SOPInstance, gov.va.med.imaging.exchange.business.dicom.InstanceFile'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTIUPointer(
 			gov.va.med.imaging.exchange.business.dicom.Series series
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTIUPointerCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.Series'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.Series.class, 
	 				"GetTIUPointerCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.Series.class 
		  			},
 					new Object[]{
				 		series
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetTIUPointerCommand' in method 'getTIUPointer' with parameters 'gov.va.med.imaging.exchange.business.dicom.Series'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteStudyAndSeriesCache(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeleteStudyAndSeriesCacheCommand' and parameters ''.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"DeleteStudyAndSeriesCacheCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeleteStudyAndSeriesCacheCommand' in method 'deleteStudyAndSeriesCache' with parameters ''.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDicomCorrectCount(
 			gov.va.med.imaging.exchange.business.dicom.DicomCorrectInfo dicomCorrectInfo
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDicomCorrectCountCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.DicomCorrectInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetDicomCorrectCountCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomCorrectInfo.class 
		  			},
 					new Object[]{
				 		dicomCorrectInfo
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDicomCorrectCountCommand' in method 'getDicomCorrectCount' with parameters 'gov.va.med.imaging.exchange.business.dicom.DicomCorrectInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processNonDicomFiles(
 			java.lang.String studyUid
 		 			, gov.va.med.imaging.exchange.business.dicom.importer.ImporterWorkItem importerWorkItem
 		 			, gov.va.med.imaging.exchange.business.dicom.importer.Reconciliation reconciliation
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrumentConfig
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessNonDicomFilesCommand' and parameters 'java.lang.String, gov.va.med.imaging.exchange.business.dicom.importer.ImporterWorkItem, gov.va.med.imaging.exchange.business.dicom.importer.Reconciliation, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"ProcessNonDicomFilesCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, gov.va.med.imaging.exchange.business.dicom.importer.ImporterWorkItem.class, gov.va.med.imaging.exchange.business.dicom.importer.Reconciliation.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class 
		  			},
 					new Object[]{
				 		studyUid,importerWorkItem,reconciliation,instrumentConfig
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessNonDicomFilesCommand' in method 'processNonDicomFiles' with parameters 'java.lang.String, gov.va.med.imaging.exchange.business.dicom.importer.ImporterWorkItem, gov.va.med.imaging.exchange.business.dicom.importer.Reconciliation, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postCFindResults(
 			gov.va.med.imaging.exchange.business.dicom.CFindResults results
 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 			, java.util.HashSet<gov.va.med.imaging.exchange.business.dicom.DicomMap> mappingSet
 			, java.util.concurrent.LinkedBlockingQueue<gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet> queue
 			, gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet lastBag
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostCFindResultsCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.CFindResults, gov.va.med.imaging.exchange.business.dicom.DicomAE, java.util.HashSet, java.util.concurrent.LinkedBlockingQueue, gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostCFindResultsCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.dicom.CFindResults.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, java.util.HashSet.class, java.util.concurrent.LinkedBlockingQueue.class, gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class 
		  		},
				new Object[]{
			 		results,dicomAE,mappingSet,queue,lastBag
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostCFindResultsCommand' in method 'postCFindResults' with parameters 'gov.va.med.imaging.exchange.business.dicom.CFindResults, gov.va.med.imaging.exchange.business.dicom.DicomAE, java.util.HashSet, java.util.concurrent.LinkedBlockingQueue, gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomDataSet(
 			gov.va.med.imaging.dicom.scu.storagescu.interfaces.IStoreSCUControl scu
 			, java.util.concurrent.LinkedBlockingQueue<gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet> queue
 			, gov.va.med.imaging.dicom.common.utils.Publisher subOperationsPublisher
 			, gov.va.med.imaging.dicom.dcftoolkit.common.observer.SubOperationsStatus subOperationsStatus
 			, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver cancelMove
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostDicomDataSetCommand' and parameters 'gov.va.med.imaging.dicom.scu.storagescu.interfaces.IStoreSCUControl, java.util.concurrent.LinkedBlockingQueue, gov.va.med.imaging.dicom.common.utils.Publisher, gov.va.med.imaging.dicom.dcftoolkit.common.observer.SubOperationsStatus, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostDicomDataSetCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.dicom.scu.storagescu.interfaces.IStoreSCUControl.class, java.util.concurrent.LinkedBlockingQueue.class, gov.va.med.imaging.dicom.common.utils.Publisher.class, gov.va.med.imaging.dicom.dcftoolkit.common.observer.SubOperationsStatus.class, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver.class 
		  		},
				new Object[]{
			 		scu,queue,subOperationsPublisher,subOperationsStatus,cancelMove
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostDicomDataSetCommand' in method 'postDicomDataSet' with parameters 'gov.va.med.imaging.dicom.scu.storagescu.interfaces.IStoreSCUControl, java.util.concurrent.LinkedBlockingQueue, gov.va.med.imaging.dicom.common.utils.Publisher, gov.va.med.imaging.dicom.dcftoolkit.common.observer.SubOperationsStatus, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDicomInstanceUpdateInfo(
 			gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo instanceStorageInfo
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDicomInstanceUpdateInfoCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomInstanceUpdateInfo.class, 
	 				"GetDicomInstanceUpdateInfoCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo.class 
		  			},
 					new Object[]{
				 		instanceStorageInfo
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDicomInstanceUpdateInfoCommand' in method 'getDicomInstanceUpdateInfo' with parameters 'gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getOrderListForPatient(
 			gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter orderFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetOrderListForPatientCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.Order.class, 
 				"GetOrderListForPatientCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter.class 
	  			},
				new Object[]{
			 		orderFilter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetOrderListForPatientCommand' in method 'getOrderListForPatient' with parameters 'gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postRadiationDose(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patient
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedure
 		 			, gov.va.med.imaging.exchange.business.dicom.Study study
 		 			, gov.va.med.imaging.exchange.business.dicom.Series series
 		 			, gov.va.med.imaging.exchange.business.dicom.rdsr.Dose dose
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostRadiationDoseCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.PatientRef, gov.va.med.imaging.exchange.business.dicom.ProcedureRef, gov.va.med.imaging.exchange.business.dicom.Study, gov.va.med.imaging.exchange.business.dicom.Series, gov.va.med.imaging.exchange.business.dicom.rdsr.Dose'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostRadiationDoseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, gov.va.med.imaging.exchange.business.dicom.Study.class, gov.va.med.imaging.exchange.business.dicom.Series.class, gov.va.med.imaging.exchange.business.dicom.rdsr.Dose.class 
		  			},
 					new Object[]{
				 		patient,procedure,study,series,dose
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostRadiationDoseCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processRadiationDose(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.PatientRef patient
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedure
 		 			, gov.va.med.imaging.exchange.business.dicom.Study study
 		 			, gov.va.med.imaging.exchange.business.dicom.Series series
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessRadiationDoseCommand' and parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.PatientRef, gov.va.med.imaging.exchange.business.dicom.ProcedureRef, gov.va.med.imaging.exchange.business.dicom.Study, gov.va.med.imaging.exchange.business.dicom.Series'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"ProcessRadiationDoseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, gov.va.med.imaging.exchange.business.dicom.Study.class, gov.va.med.imaging.exchange.business.dicom.Series.class 
		  			},
 					new Object[]{
				 		dds,patient,procedure,study,series
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessRadiationDoseCommand'.");		  		
 		}

 }