/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       BECKEC
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.dicom.router.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class InternalDicomRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements InternalDicomRouter
 {
	private static InternalDicomRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized InternalDicomRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new InternalDicomRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected InternalDicomRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults getPatientStudyLookupResults(
 			gov.va.med.imaging.exchange.business.dicom.PatientStudyInfo patientStudyInfo
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults> command = (Command<gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults.class, 
	 				"GetPatientStudyLookupResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientStudyInfo.class 
		  			},
 					new Object[]{
				 		patientStudyInfo
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientStudyLookupResultsCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.UIDCheckResult getStudyUIDCheckResult(
 			gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo uidCheckInfo
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.UIDCheckResult> command = (Command<gov.va.med.imaging.exchange.business.dicom.UIDCheckResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.UIDCheckResult.class, 
	 				"GetStudyUIDCheckResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo.class 
		  			},
 					new Object[]{
				 		uidCheckInfo
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyUIDCheckResultCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.UIDCheckResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.UIDCheckResult getSeriesUIDCheckResult(
 			gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo uidCheckInfo
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.UIDCheckResult> command = (Command<gov.va.med.imaging.exchange.business.dicom.UIDCheckResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.UIDCheckResult.class, 
	 				"GetSeriesUIDCheckResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo.class 
		  			},
 					new Object[]{
				 		uidCheckInfo
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetSeriesUIDCheckResultCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.UIDCheckResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.UIDCheckResult getSOPInstanceUIDCheckResult(
 			gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo uidCheckInfo
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.UIDCheckResult> command = (Command<gov.va.med.imaging.exchange.business.dicom.UIDCheckResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.UIDCheckResult.class, 
	 				"GetSOPInstanceUIDCheckResultCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.UIDCheckInfo.class 
		  			},
 					new Object[]{
				 		uidCheckInfo
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetSOPInstanceUIDCheckResultCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.UIDCheckResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.DicomUid getDicomUid(
 			java.lang.String accessionNumber
 		 			, java.lang.String siteId
 		 			, java.lang.String instrument
 		 			, java.lang.String type
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.DicomUid> command = (Command<gov.va.med.imaging.exchange.business.dicom.DicomUid>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomUid.class, 
	 				"GetDicomUidCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		accessionNumber,siteId,instrument,type
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDicomUidCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.DicomUid commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postDicomCorrect(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults patientStudyLookupResults
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, boolean isNetworkImport
 		 			, java.lang.String originIndex
 		 			, java.io.InputStream inputStream
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostDicomCorrectCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, boolean.class, java.lang.String.class, java.io.InputStream.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,patientStudyLookupResults,instrument,isNetworkImport,originIndex,inputStream
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDicomCorrectCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postDicomInstanceTo2005(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, java.nio.channels.ReadableByteChannel instanceChannel
 		 			, java.io.InputStream inputStream
 		 			, java.lang.String originIndex
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostDicomInstanceTo2005Command",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, java.nio.channels.ReadableByteChannel.class, java.io.InputStream.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,instrument,instanceChannel,inputStream,originIndex
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDicomInstanceTo2005Command");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postDicomInstanceToNewStructure(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults patientStudyLookupResults
 		 			, gov.va.med.imaging.exchange.business.dicom.UIDCheckResults uidCheckResults
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, int iodValidationStatus
 		 			, java.nio.channels.ReadableByteChannel instanceChannel
 		 			, java.io.InputStream inputStream
 		 			, java.lang.String originIndex
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostDicomInstanceToNewStructureCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.PatientStudyLookupResults.class, gov.va.med.imaging.exchange.business.dicom.UIDCheckResults.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, int.class, java.nio.channels.ReadableByteChannel.class, java.io.InputStream.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,patientStudyLookupResults,uidCheckResults,instrument,iodValidationStatus,instanceChannel,inputStream,originIndex
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDicomInstanceToNewStructureCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem postStoreCommitWorkItem(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem scWI
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem> command = (Command<gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, 
	 				"PostStoreCommitWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class 
		  			},
 					new Object[]{
				 		scWI
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostStoreCommitWorkItemCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem> getStoreCommitWorkItemList(
 			gov.va.med.imaging.exchange.business.dicom.SCWorkItemQueryParameters parameters
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, 
 				"GetStoreCommitWorkItemListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.dicom.SCWorkItemQueryParameters.class 
	  			},
				new Object[]{
			 		parameters
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetStoreCommitWorkItemListCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem getStoreCommitWorkItem(
 			java.lang.String scWIID
 		 			, java.lang.Boolean doProcess
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem> command = (Command<gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, 
	 				"GetStoreCommitWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		scWIID,doProcess
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStoreCommitWorkItemCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postStoreCommitWorkItemStatus(
 			java.lang.String scWIID
 		 			, java.lang.String status
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostStoreCommitWorkItemStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		scWIID,status
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostStoreCommitWorkItemStatusCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postDeleteStoreCommitWorkItem(
 			java.lang.String scWIID
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostDeleteStoreCommitWorkItemCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		scWIID
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDeleteStoreCommitWorkItemCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer postSendSCResponse(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem scWI
 		 			, gov.va.med.imaging.core.router.commands.StorageCommitWaiter scWaiter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"PostSendSCResponseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, gov.va.med.imaging.core.router.commands.StorageCommitWaiter.class 
		  			},
 					new Object[]{
				 		scWI,scWaiter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostSendSCResponseCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.DicomStorageResults postDicomInstance(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, gov.va.med.imaging.dicom.common.DicomFileMetaInfo metaData
 		 			, int iodValidationStatus
 		 			, boolean isAlreadyReconciled
 		 			, java.lang.String originIndex
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.DicomStorageResults> command = (Command<gov.va.med.imaging.exchange.business.dicom.DicomStorageResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomStorageResults.class, 
	 				"PostDicomInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, gov.va.med.imaging.dicom.common.DicomFileMetaInfo.class, int.class, boolean.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,instrument,metaData,iodValidationStatus,isAlreadyReconciled,originIndex
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDicomInstanceCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.DicomStorageResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.PatientRef getOrCreatePatientRef(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patientRef
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.PatientRef> command = (Command<gov.va.med.imaging.exchange.business.dicom.PatientRef>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, 
	 				"GetOrCreatePatientRefCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class 
		  			},
 					new Object[]{
				 		patientRef
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetOrCreatePatientRefCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.PatientRef commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.ProcedureRef getOrCreateProcedureRef(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patientRef
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedureRef
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.ProcedureRef> command = (Command<gov.va.med.imaging.exchange.business.dicom.ProcedureRef>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, 
	 				"GetOrCreateProcedureRefCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class 
		  			},
 					new Object[]{
				 		patientRef,procedureRef
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetOrCreateProcedureRefCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.ProcedureRef commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.Study getOrCreateStudy(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patientRef
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedureRef
 		 			, gov.va.med.imaging.exchange.business.dicom.Study study
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.Study> command = (Command<gov.va.med.imaging.exchange.business.dicom.Study>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.Study.class, 
	 				"GetOrCreateStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, gov.va.med.imaging.exchange.business.dicom.Study.class 
		  			},
 					new Object[]{
				 		patientRef,procedureRef,study
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetOrCreateStudyCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.Study commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.Series getOrCreateSeries(
 			gov.va.med.imaging.exchange.business.dicom.Study study
 		 			, gov.va.med.imaging.exchange.business.dicom.Series series
 		 			, java.lang.Integer iodValidationStatus
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.Series> command = (Command<gov.va.med.imaging.exchange.business.dicom.Series>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.Series.class, 
	 				"GetOrCreateSeriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.Study.class, gov.va.med.imaging.exchange.business.dicom.Series.class, java.lang.Integer.class 
		  			},
 					new Object[]{
				 		study,series,iodValidationStatus
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetOrCreateSeriesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.Series commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.SOPInstance postSOPInstance(
 			gov.va.med.imaging.exchange.business.dicom.Series series
 		 			, gov.va.med.imaging.exchange.business.dicom.SOPInstance sopInstance
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.SOPInstance> command = (Command<gov.va.med.imaging.exchange.business.dicom.SOPInstance>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.SOPInstance.class, 
	 				"PostSOPInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.Series.class, gov.va.med.imaging.exchange.business.dicom.SOPInstance.class 
		  			},
 					new Object[]{
				 		series,sopInstance
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostSOPInstanceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.SOPInstance commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.InstanceFile postInstanceFile(
 			gov.va.med.imaging.exchange.business.dicom.SOPInstance sopInstance
 		 			, gov.va.med.imaging.exchange.business.dicom.InstanceFile instanceFile
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.InstanceFile> command = (Command<gov.va.med.imaging.exchange.business.dicom.InstanceFile>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.InstanceFile.class, 
	 				"PostInstanceFileCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.SOPInstance.class, gov.va.med.imaging.exchange.business.dicom.InstanceFile.class 
		  			},
 					new Object[]{
				 		sopInstance,instanceFile
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostInstanceFileCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.InstanceFile commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.Series getTIUPointer(
 			gov.va.med.imaging.exchange.business.dicom.Series series
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.Series> command = (Command<gov.va.med.imaging.exchange.business.dicom.Series>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.Series.class, 
	 				"GetTIUPointerCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.Series.class 
		  			},
 					new Object[]{
				 		series
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetTIUPointerCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.Series commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean deleteStudyAndSeriesCache(
 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"DeleteStudyAndSeriesCacheCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DeleteStudyAndSeriesCacheCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getDicomCorrectCount(
 			gov.va.med.imaging.exchange.business.dicom.DicomCorrectInfo dicomCorrectInfo
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetDicomCorrectCountCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomCorrectInfo.class 
		  			},
 					new Object[]{
				 		dicomCorrectInfo
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDicomCorrectCountCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean processNonDicomFiles(
 			java.lang.String studyUid
 		 			, gov.va.med.imaging.exchange.business.dicom.importer.ImporterWorkItem importerWorkItem
 		 			, gov.va.med.imaging.exchange.business.dicom.importer.Reconciliation reconciliation
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrumentConfig
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"ProcessNonDicomFilesCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, gov.va.med.imaging.exchange.business.dicom.importer.ImporterWorkItem.class, gov.va.med.imaging.exchange.business.dicom.importer.Reconciliation.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class 
		  			},
 					new Object[]{
				 		studyUid,importerWorkItem,reconciliation,instrumentConfig
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessNonDicomFilesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postCFindResults(
 			gov.va.med.imaging.exchange.business.dicom.CFindResults results
 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 			, java.util.HashSet<gov.va.med.imaging.exchange.business.dicom.DicomMap> mappingSet
 			, java.util.concurrent.LinkedBlockingQueue<gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet> queue
 			, gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet lastBag
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostCFindResultsCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.dicom.CFindResults.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, java.util.HashSet.class, java.util.concurrent.LinkedBlockingQueue.class, gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class 
		  		},
				new Object[]{
			 		results,dicomAE,mappingSet,queue,lastBag
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomDataSet(
 			gov.va.med.imaging.dicom.scu.storagescu.interfaces.IStoreSCUControl scu
 			, java.util.concurrent.LinkedBlockingQueue<gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet> queue
 			, gov.va.med.imaging.dicom.common.utils.Publisher subOperationsPublisher
 			, gov.va.med.imaging.dicom.dcftoolkit.common.observer.SubOperationsStatus subOperationsStatus
 			, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver cancelMove
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostDicomDataSetCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.dicom.scu.storagescu.interfaces.IStoreSCUControl.class, java.util.concurrent.LinkedBlockingQueue.class, gov.va.med.imaging.dicom.common.utils.Publisher.class, gov.va.med.imaging.dicom.dcftoolkit.common.observer.SubOperationsStatus.class, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver.class 
		  		},
				new Object[]{
			 		scu,queue,subOperationsPublisher,subOperationsStatus,cancelMove
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.DicomInstanceUpdateInfo getDicomInstanceUpdateInfo(
 			gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo instanceStorageInfo
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.DicomInstanceUpdateInfo> command = (Command<gov.va.med.imaging.exchange.business.dicom.DicomInstanceUpdateInfo>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomInstanceUpdateInfo.class, 
	 				"GetDicomInstanceUpdateInfoCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo.class 
		  			},
 					new Object[]{
				 		instanceStorageInfo
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDicomInstanceUpdateInfoCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.dicom.DicomInstanceUpdateInfo commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.Order> getOrderListForPatient(
 			gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter orderFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.importer.Order.class, 
 				"GetOrderListForPatientCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.business.dicom.importer.OrderFilter.class 
	  			},
				new Object[]{
			 		orderFilter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetOrderListForPatientCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.importer.Order> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postRadiationDose(
 			gov.va.med.imaging.exchange.business.dicom.PatientRef patient
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedure
 		 			, gov.va.med.imaging.exchange.business.dicom.Study study
 		 			, gov.va.med.imaging.exchange.business.dicom.Series series
 		 			, gov.va.med.imaging.exchange.business.dicom.rdsr.Dose dose
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostRadiationDoseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, gov.va.med.imaging.exchange.business.dicom.Study.class, gov.va.med.imaging.exchange.business.dicom.Series.class, gov.va.med.imaging.exchange.business.dicom.rdsr.Dose.class 
		  			},
 					new Object[]{
				 		patient,procedure,study,series,dose
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostRadiationDoseCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processRadiationDose(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.PatientRef patient
 		 			, gov.va.med.imaging.exchange.business.dicom.ProcedureRef procedure
 		 			, gov.va.med.imaging.exchange.business.dicom.Study study
 		 			, gov.va.med.imaging.exchange.business.dicom.Series series
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"ProcessRadiationDoseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.PatientRef.class, gov.va.med.imaging.exchange.business.dicom.ProcedureRef.class, gov.va.med.imaging.exchange.business.dicom.Study.class, gov.va.med.imaging.exchange.business.dicom.Series.class 
		  			},
 					new Object[]{
				 		dds,patient,procedure,study,series
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessRadiationDoseCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 }