/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.dicom;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class DicomRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public DicomRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCFindResults(
 			gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters request
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCFindResultsCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.CFindResults.class, 
	 				"GetCFindResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters.class 
		  			},
 					new Object[]{
				 		request
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCFindResultsCommand' in method 'getCFindResults' with parameters 'gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processCFindResults(
 			gov.va.med.imaging.exchange.business.dicom.CFindResults results
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback cFindCallback
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessCFindResultsCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.CFindResults, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"ProcessCFindResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.CFindResults.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback.class 
		  			},
 					new Object[]{
				 		results,dicomAE,cFindCallback
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessCFindResultsCommand' in method 'processCFindResults' with parameters 'gov.va.med.imaging.exchange.business.dicom.CFindResults, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyDetails(
 			java.lang.String studyId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyDetailsCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetStudyDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		studyId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyDetailsCommand' in method 'getStudyDetails' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processCMoveResults(
 			java.lang.String storeAETitle
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters request
 		 			, java.util.Observer scpListener
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessCMoveResultsCommand' and parameters 'java.lang.String, gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters, java.util.Observer'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver.class, 
	 				"ProcessCMoveResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters.class, java.util.Observer.class 
		  			},
 					new Object[]{
				 		storeAETitle,request,scpListener
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessCMoveResultsCommand' in method 'processCMoveResults' with parameters 'java.lang.String, gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters, java.util.Observer'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCMoveResults(
 			gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters request
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetCMoveResultsCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.CMoveResults.class, 
	 				"GetCMoveResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters.class 
		  			},
 					new Object[]{
				 		request
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetCMoveResultsCommand' in method 'getCMoveResults' with parameters 'gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomInstanceSet(
 			java.lang.String storeAETitle
 			, gov.va.med.imaging.exchange.business.dicom.DicomInstanceSet instances
 			, java.util.Observer scpListener
 			, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver cancelMove
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostDicomInstanceSetCommand' and parameters 'java.lang.String, gov.va.med.imaging.exchange.business.dicom.DicomInstanceSet, java.util.Observer, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostDicomInstanceSetCommand",
	 			"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.imaging.exchange.business.dicom.DicomInstanceSet.class, java.util.Observer.class, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver.class 
		  		},
				new Object[]{
			 		storeAETitle,instances,scpListener,cancelMove
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostDicomInstanceSetCommand' in method 'postDicomInstanceSet' with parameters 'java.lang.String, gov.va.med.imaging.exchange.business.dicom.DicomInstanceSet, java.util.Observer, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDicomDataSet(
 			gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo instance
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDicomDataSetCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, 
	 				"GetDicomDataSetCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo.class 
		  			},
 					new Object[]{
				 		instance
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDicomDataSetCommand' in method 'getDicomDataSet' with parameters 'gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageDetails(
 			java.lang.String image
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageDetailsCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetImageDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		image
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageDetailsCommand' in method 'getImageDetails' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getRemoteAE(
 			gov.va.med.imaging.exchange.business.dicom.DicomAE.searchMode findMode
 		 			, java.lang.String aeTitle
 		 			, java.lang.String siteNumber
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetRemoteAECommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.DicomAE.searchMode, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomAE.class, 
	 				"GetRemoteAECommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomAE.searchMode.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		findMode,aeTitle,siteNumber
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetRemoteAECommand' in method 'getRemoteAE' with parameters 'gov.va.med.imaging.exchange.business.dicom.DicomAE.searchMode, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getModalityDeviceAuthenticated(
 			java.lang.String manufacturer
 		 			, java.lang.String model
 		 			, java.lang.String softwareVersion
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetModalityDeviceAuthenticatedCommand' and parameters 'java.lang.String, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"GetModalityDeviceAuthenticatedCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		manufacturer,model,softwareVersion
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetModalityDeviceAuthenticatedCommand' in method 'getModalityDeviceAuthenticated' with parameters 'java.lang.String, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDicomGatewayConfig(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDicomGatewayConfigCommand' and parameters ''.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"GetDicomGatewayConfigCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDicomGatewayConfigCommand' in method 'getDicomGatewayConfig' with parameters ''.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDgwInstrumentList(
 			java.lang.String hostName
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDgwInstrumentListCommand' and parameters 'java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, 
 				"GetDgwInstrumentListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		hostName
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDgwInstrumentListCommand' in method 'getDgwInstrumentList' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDgwModalityList(
 			java.lang.String hostName
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDgwModalityListCommand' and parameters 'java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.ModalityConfig.class, 
 				"GetDgwModalityListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		hostName
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDgwModalityListCommand' in method 'getDgwModalityList' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDgwEmailInfo(
 			java.lang.String hostName
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDgwEmailInfoCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.DGWEmailInfo.class, 
	 				"GetDgwEmailInfoCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		hostName
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDgwEmailInfoCommand' in method 'getDgwEmailInfo' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDgwUIDActionTable(
 			java.lang.String type
 		 			, java.lang.String subType
 		 			, java.lang.String action
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDgwUIDActionTableCommand' and parameters 'java.lang.String, java.lang.String, java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.UIDActionConfig.class, 
 				"GetDgwUIDActionTableCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.String.class, java.lang.String.class 
	  			},
				new Object[]{
			 		type,subType,action
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDgwUIDActionTableCommand' in method 'getDgwUIDActionTable' with parameters 'java.lang.String, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomInstance(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, gov.va.med.imaging.dicom.common.DicomFileMetaInfo metaData
 		 			, int iodValidationStatus
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDicomInstanceCommand' and parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, gov.va.med.imaging.dicom.common.DicomFileMetaInfo, int'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomStorageResults.class, 
	 				"PostDicomInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, gov.va.med.imaging.dicom.common.DicomFileMetaInfo.class, int.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,instrument,metaData,iodValidationStatus
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDicomInstanceCommand' in method 'postDicomInstance' with parameters 'gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig, gov.va.med.imaging.dicom.common.DicomFileMetaInfo, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomStorageCommit(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem sCWI
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDicomStorageCommitCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"PostDicomStorageCommitCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class 
		  			},
 					new Object[]{
				 		sCWI,dicomAE,instrument
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDicomStorageCommitCommand' in method 'postDicomStorageCommit' with parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem, gov.va.med.imaging.exchange.business.dicom.DicomAE, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomStorageCommitResponse(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem sCWI
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostDicomStorageCommitResponseCommand' and parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"PostDicomStorageCommitResponseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class 
		  			},
 					new Object[]{
				 		sCWI
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostDicomStorageCommitResponseCommand' in method 'postDicomStorageCommitResponse' with parameters 'gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postToEmailQueue(
 			gov.va.med.imaging.exchange.business.EmailMessage email
 		 			, java.lang.String scpContext
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostToEmailQueueCommand' and parameters 'gov.va.med.imaging.exchange.business.EmailMessage, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostToEmailQueueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.EmailMessage.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		email,scpContext
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostToEmailQueueCommand' in method 'postToEmailQueue' with parameters 'gov.va.med.imaging.exchange.business.EmailMessage, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getRadiationDoseDetails(
 			java.lang.String patientDfn
 		 			, java.lang.String accessionNumber
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetRadiationDoseDetailsCommand' and parameters 'java.lang.String, java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.rdsr.Dose.class, 
 				"GetRadiationDoseDetailsCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.String.class 
	  			},
				new Object[]{
			 		patientDfn,accessionNumber
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetRadiationDoseDetailsCommand' in method 'getRadiationDoseDetails' with parameters 'java.lang.String, java.lang.String'.");
 		}

 }