/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.dicom;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class DicomRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements DicomRouter
 {
	private static DicomRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized DicomRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new DicomRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected DicomRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.CFindResults getCFindResults(
 			gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters request
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.CFindResults> command = (Command<gov.va.med.imaging.exchange.business.dicom.CFindResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.CFindResults.class, 
	 				"GetCFindResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters.class 
		  			},
 					new Object[]{
				 		request
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetCFindResultsCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.CFindResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean processCFindResults(
 			gov.va.med.imaging.exchange.business.dicom.CFindResults results
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback cFindCallback
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"ProcessCFindResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.CFindResults.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback.class 
		  			},
 					new Object[]{
				 		results,dicomAE,cFindCallback
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessCFindResultsCommand");
		
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getStudyDetails(
 			java.lang.String studyId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetStudyDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		studyId
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyDetailsCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver processCMoveResults(
 			java.lang.String storeAETitle
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters request
 		 			, java.util.Observer scpListener
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver> command = (Command<gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver.class, 
	 				"ProcessCMoveResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters.class, java.util.Observer.class 
		  			},
 					new Object[]{
				 		storeAETitle,request,scpListener
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessCMoveResultsCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.CMoveResults getCMoveResults(
 			gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters request
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.CMoveResults> command = (Command<gov.va.med.imaging.exchange.business.dicom.CMoveResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.CMoveResults.class, 
	 				"GetCMoveResultsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters.class 
		  			},
 					new Object[]{
				 		request
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetCMoveResultsCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.CMoveResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postDicomInstanceSet(
 			java.lang.String storeAETitle
 			, gov.va.med.imaging.exchange.business.dicom.DicomInstanceSet instances
 			, java.util.Observer scpListener
 			, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver cancelMove
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostDicomInstanceSetCommand",
	 			"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.imaging.exchange.business.dicom.DicomInstanceSet.class, java.util.Observer.class, gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver.class 
		  		},
				new Object[]{
			 		storeAETitle,instances,scpListener,cancelMove
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet getDicomDataSet(
 			gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo instance
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet> command = (Command<gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, 
	 				"GetDicomDataSetCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.InstanceStorageInfo.class 
		  			},
 					new Object[]{
				 		instance
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDicomDataSetCommand");
		
      
        gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getImageDetails(
 			java.lang.String image
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetImageDetailsCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		image
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageDetailsCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.DicomAE getRemoteAE(
 			gov.va.med.imaging.exchange.business.dicom.DicomAE.searchMode findMode
 		 			, java.lang.String aeTitle
 		 			, java.lang.String siteNumber
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.DicomAE> command = (Command<gov.va.med.imaging.exchange.business.dicom.DicomAE>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomAE.class, 
	 				"GetRemoteAECommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.DicomAE.searchMode.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		findMode,aeTitle,siteNumber
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetRemoteAECommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.DicomAE commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean getModalityDeviceAuthenticated(
 			java.lang.String manufacturer
 		 			, java.lang.String model
 		 			, java.lang.String softwareVersion
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"GetModalityDeviceAuthenticatedCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		manufacturer,model,softwareVersion
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetModalityDeviceAuthenticatedCommand");
		
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean getDicomGatewayConfig(
 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"GetDicomGatewayConfigCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDicomGatewayConfigCommand");
		
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.InstrumentConfig> getDgwInstrumentList(
 			java.lang.String hostName
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, 
 				"GetDgwInstrumentListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		hostName
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDgwInstrumentListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.InstrumentConfig> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.ModalityConfig> getDgwModalityList(
 			java.lang.String hostName
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.ModalityConfig.class, 
 				"GetDgwModalityListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class 
	  			},
				new Object[]{
			 		hostName
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDgwModalityListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.ModalityConfig> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.DGWEmailInfo getDgwEmailInfo(
 			java.lang.String hostName
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.DGWEmailInfo> command = (Command<gov.va.med.imaging.exchange.business.dicom.DGWEmailInfo>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.DGWEmailInfo.class, 
	 				"GetDgwEmailInfoCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		hostName
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDgwEmailInfoCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.DGWEmailInfo commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.UIDActionConfig> getDgwUIDActionTable(
 			java.lang.String type
 		 			, java.lang.String subType
 		 			, java.lang.String action
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.UIDActionConfig.class, 
 				"GetDgwUIDActionTableCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.String.class, java.lang.String.class 
	  			},
				new Object[]{
			 		type,subType,action
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDgwUIDActionTableCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.UIDActionConfig> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.dicom.DicomStorageResults postDicomInstance(
 			gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet dds
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 			, gov.va.med.imaging.dicom.common.DicomFileMetaInfo metaData
 		 			, int iodValidationStatus
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.dicom.DicomStorageResults> command = (Command<gov.va.med.imaging.exchange.business.dicom.DicomStorageResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.dicom.DicomStorageResults.class, 
	 				"PostDicomInstanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class, gov.va.med.imaging.dicom.common.DicomFileMetaInfo.class, int.class 
		  			},
 					new Object[]{
				 		dds,dicomAE,instrument,metaData,iodValidationStatus
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDicomInstanceCommand");
		
      
        gov.va.med.imaging.exchange.business.dicom.DicomStorageResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer postDicomStorageCommit(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem sCWI
 		 			, gov.va.med.imaging.exchange.business.dicom.DicomAE dicomAE
 		 			, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig instrument
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"PostDicomStorageCommitCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class, gov.va.med.imaging.exchange.business.dicom.DicomAE.class, gov.va.med.imaging.exchange.business.dicom.InstrumentConfig.class 
		  			},
 					new Object[]{
				 		sCWI,dicomAE,instrument
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDicomStorageCommitCommand");
		
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer postDicomStorageCommitResponse(
 			gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem sCWI
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"PostDicomStorageCommitResponseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.dicom.StorageCommitWorkItem.class 
		  			},
 					new Object[]{
				 		sCWI
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostDicomStorageCommitResponseCommand");
		
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postToEmailQueue(
 			gov.va.med.imaging.exchange.business.EmailMessage email
 		 			, java.lang.String scpContext
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostToEmailQueueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.EmailMessage.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		email,scpContext
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostToEmailQueueCommand");
		
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.dicom.rdsr.Dose> getRadiationDoseDetails(
 			java.lang.String patientDfn
 		 			, java.lang.String accessionNumber
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.dicom.rdsr.Dose.class, 
 				"GetRadiationDoseDetailsCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, java.lang.String.class 
	  			},
				new Object[]{
			 		patientDfn,accessionNumber
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetRadiationDoseDetailsCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.dicom.rdsr.Dose> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 }