/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.memory;

import java.net.URI;
import java.net.URISyntaxException;

import gov.va.med.imaging.storage.cache.AbstractCacheFactoryTest;
import gov.va.med.imaging.storage.cache.Cache;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;
import gov.va.med.imaging.storage.cache.impl.CacheFactory;
import gov.va.med.imaging.storage.cache.impl.memory.MemoryCache;

/**
 * @author       DNS
 *
 */
public class CacheFactoryTest 
extends AbstractCacheFactoryTest
{	
	@Override
	protected URI getCacheUri() 
	throws URISyntaxException
	{
		return new URI(MemoryCache.protocol + "://" + this.getName() + "?" + "maxSize=65536&maxInstanceCount=32");
	}

	@Override
	protected String getPrototypeName()
	{
		return null;
	}
	
	public void testCreateType() 
	throws URISyntaxException, CacheException
	{
		CacheFactory cacheFactory = CacheFactory.getSingleton();
		Cache cache = null;
		
		cache = cacheFactory.createCache(this.getName() + "-SimpleCreate", getCacheUri(), (String)null);
		
		assertTrue(cache instanceof MemoryCache);
		MemoryCache mockCache = (MemoryCache)cache;
		assertEquals( 65536L, mockCache.getMaxCacheSize() );
		assertEquals( 32, mockCache.getMaxInstanceCount() );
		
	}
	
}
