/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.jcifs;

import gov.va.med.imaging.storage.cache.AbstractCacheTest;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;

import org.apache.log4j.Logger;

import junit.framework.TestCase;

/**
 * @author vhaiswbeckec
 *
 */
public class TestCacheCreation 
extends TestCase
{
	private String localhostName;
	private String shareName = "/SmbVixCache/";
	private String shareUser = "VixCacheUser";
	private String shareUserPwd = "R00tbeer";
	
	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	@Override
	protected void setUp() throws Exception
	{
		super.setUp();

		InetAddress localhostAddress = InetAddress.getLocalHost();
		localhostName = localhostAddress.getHostName();
		
		AbstractCacheTest.initializeLogging(this.getName());
		Logger.getRootLogger().info("Starting unit test '" + this.getName() + "' =======================================================");

		Logger.getLogger(this.getClass()).info(
				"The directory '" + shareName + 
				"' must exist on the local machine, and the user '" + shareUser + 
				"' must have full access.  Otherwise  this test will fail.");
		
		//localhostName = "ISW-BeckeC1-lt.";
	}

	/**
	 * @return the localhostName
	 */
	public String getLocalhostName()
	{
		return this.localhostName;
	}

	public void testConstructor() 
	throws URISyntaxException, CacheException
	{
		jcifs.Config.setProperty( "jcifs.util.loglevel", "4" );
		jcifs.Config.setProperty( "jcifs.resolveOrder", "DNS" );
		jcifs.Config.setProperty( "jcifs.netbios.lmhosts", "/VixConfig/jcifshosts.txt");
		
		String cacheName = "RandomName" + System.currentTimeMillis();
		URI cacheLocation = new URI("smb://" + shareUser + ":" + shareUserPwd + "@" + getLocalhostName() + shareName);
		
		System.out.println("Creating cache '" + cacheName + "' at [" + cacheLocation + "].");
		
		JcifsCache cache = JcifsCache.create(cacheName, cacheLocation);
		assertNotNull(cache);
		
		cache.addRegion(JcifsRegion.create(cache, "region1", null, 60, false));
		
		cache.setInitialized(true);
		assertTrue(cache.isInitialized());
		
		cache.setEnabled(true);
		assertTrue(cache.isEnabled());
		
	}
	
	
}
