package gov.va.med.imaging.storage.cache;

import gov.va.med.imaging.storage.cache.impl.CacheManagerImpl;
import gov.va.med.server.ServerLifecycleEvent;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;

import junit.framework.TestCase;

import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractCacheTest 
extends TestCase
{
	private Cache cache = null;
	private CacheManagerImpl cacheManager = null;
	private String localhostName;

	// by default, create a cache with the same name as the unit test
	protected String getCacheName()
	{
		return this.getName();
	}
	
	protected abstract URI getCacheUri()
	throws URISyntaxException;
	
	protected abstract String getPrototypeName();
	
	protected void setUp() 
	throws Exception
	{
		super.setUp();
		
		initializeLogging(this.getName(), Level.WARN);
		Logger.getRootLogger().info("Starting unit test '" + this.getName() + "' =======================================================");
		
		jcifs.Config.setProperty( "jcifs.util.loglevel", "4" );
		jcifs.Config.setProperty( "jcifs.resolveOrder", "DNS" );
		
		InetAddress localhostAddress = InetAddress.getLocalHost();
		localhostName = localhostAddress.getHostName();
		
		cacheManager = CacheManagerImpl.getSingleton();
		cache = cacheManager.createCache(getCacheName(), getCacheUri(), getPrototypeName());
		cache.setInitialized(true);
		cache.setEnabled(true);
		cacheManager.serverLifecycleEvent(new ServerLifecycleEvent(ServerLifecycleEvent.EventType.START));
	}

	public String getLocalhostName()
	{
		return this.localhostName;
	}

	protected void tearDown() throws Exception
	{
		cacheManager.disable(cache);
		cache.cacheLifecycleEvent(CacheLifecycleEvent.STOP);
		cacheManager.delete(cache);

		Logger.getRootLogger().info("Stopping unit test '" + this.getName() + "' =======================================================");
		super.tearDown();
	}

	/**
	 * 
	 */
	public static void initializeLogging(String name)
	{
		initializeLogging(name, Level.DEBUG);
	}
	
	public static void initializeLogging(String name, Level level)
	{
		Appender appender = null;
		
		Logger.getRootLogger().setLevel(level);
		Layout layout = new org.apache.log4j.PatternLayout("%d{DATE} %5p [%t] (%F:%L) - %m%n");
		try
		{
			appender = new org.apache.log4j.FileAppender(layout, name + ".junit.result", false);
		} 
		catch (IOException x)
		{
			appender = new org.apache.log4j.ConsoleAppender(layout);
		}
		Logger.getRootLogger().addAppender(appender);

		Appender consoleAppender = new org.apache.log4j.ConsoleAppender(layout);
		Logger.getRootLogger().addAppender(consoleAppender);
		
		// turn down clustering messages
		//Logger.getLogger("gov.va.med.imaging.cluster").setLevel(Level.WARN);
	}

	protected Cache getCache()
	{
		return cache;
	}
	
}
