/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.memory;

import gov.va.med.imaging.storage.cache.Group;
import gov.va.med.imaging.storage.cache.GroupFactory;
import gov.va.med.imaging.storage.cache.InstanceFactory;
import gov.va.med.imaging.storage.cache.events.GroupLifecycleListener;

/**
 * @author      DNS
 *
 */
public class MemoryGroupFactory 
extends GroupFactory
{
	private final GroupLifecycleListener groupLifecycleListener;
	private final InstanceFactory instanceFactory; 

	// ==================================================================================================================
	// 
	// ==================================================================================================================
	
	MemoryGroupFactory(
		GroupLifecycleListener groupLifecycleListener, 
		InstanceFactory instanceFactory)
	{
		this.groupLifecycleListener = groupLifecycleListener;
		this.instanceFactory = instanceFactory;
	}
	
	/**
	 * @return the groupLifecycleListener
	 */
	public GroupLifecycleListener getGroupLifecycleListener()
	{
		return groupLifecycleListener;
	}

	
	/**
	 * @return the instanceFactory
	 */
	public InstanceFactory getInstanceFactory()
	{
		return this.instanceFactory;
	}

	/**
	 * @see gov.va.med.imaging.storage.cache.impl.memory.GroupFactory#createGroup(java.lang.String)
	 */
	public Group create(String name)
	{
		MemoryGroup group = new MemoryGroup(name, this, getInstanceFactory());
		if(getGroupLifecycleListener() != null)
			group.registerListener( getGroupLifecycleListener() );
		
		
		return group;
	}

}
