package gov.va.med.imaging.storage.cache.impl.jcifs.memento;

import gov.va.med.imaging.storage.cache.impl.memento.PersistentRegionMemento;
import gov.va.med.imaging.storage.cache.memento.ByteChannelFactoryMemento;
import gov.va.med.imaging.storage.cache.memento.CacheMemento;
import gov.va.med.imaging.storage.cache.memento.EvictionTimerImplMemento;
import gov.va.med.imaging.storage.cache.memento.RegionMemento;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * This class contains all of the fields required to persist and recreate the Cache instance. 
 * 
 * @author      DNS
 *
 */
public class JcifsCacheMemento
extends CacheMemento
implements Serializable
{
	private static final long serialVersionUID = 1;
	private String root;
	private EvictionTimerImplMemento evictionTimer;
	private ByteChannelFactoryMemento byteChannelConfiguration = null;
	
	public JcifsCacheMemento() {	}

	public String getRoot()
	{
		return this.root;
	}

	public void setRoot(String root)
	{
		this.root = root;
	}

	private List<? extends RegionMemento> regionMementos = new ArrayList<PersistentRegionMemento>();
	public List<? extends RegionMemento> getRegionMementos()
	{
		return this.regionMementos;
	}
	
	public void setRegionMementos(List<? extends RegionMemento> regionMementos)
	{
		this.regionMementos = regionMementos;
	}
	
	public ByteChannelFactoryMemento getByteChannelConfiguration()
	{
		return this.byteChannelConfiguration;
	}
	
	public void setByteChannelConfiguration(ByteChannelFactoryMemento byteChannelConfiguration)
	{
		this.byteChannelConfiguration = byteChannelConfiguration;
	}

	public void setDefaultEvictionTimer(EvictionTimerImplMemento memento)
	{
		this.evictionTimer = memento;
	}
	
	public EvictionTimerImplMemento getDefaultEvictionTimer()
	{
		return evictionTimer;
	}
}