/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl.jcifs;

import org.apache.log4j.Logger;

import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;

/**
 * @author        DNS
 *
 */
public class SmbUtilities
{
	/**
	 * Get all of the files in our directory.
	 * All files (not directories) are considered child instances of this group.
	 * 
	 * @return
	 */
	public SmbFile[] getPersistentChildren(SmbFile directory, boolean includeDirectories, boolean includeFiles)
	{
		SmbFile[] childFiles = null;
		try
		{
			childFiles = directory.listFiles( new SmbFileDirectoryFilter(includeDirectories, includeFiles) );
		} 
		catch (SmbException x)
		{
			Logger.getLogger(SmbUtilities.class).error(x);
		}

		// return an empty array even if the group directory does not exist
		return childFiles == null ? new SmbFile[]{} : childFiles;
	}
	
	private class SmbFileDirectoryFilter
	implements SmbFileFilter
	{
		private boolean includeDirectories;
		private boolean includeFiles;
		
		SmbFileDirectoryFilter(boolean includeDirectories, boolean includeFiles)
		{
			this.includeDirectories = includeDirectories;
			this.includeFiles = includeFiles;
		}
		
		public boolean accept(SmbFile pathname)
		{
			try
			{
				return 
				(includeDirectories && pathname.isDirectory()) || 
				(includeFiles && ! pathname.isDirectory());
			} 
			catch (SmbException x)
			{
				Logger.getLogger(SmbUtilities.class).error(x);
				return false;
			}
		}
	}

}
