/**
 * 
 */
package gov.va.med.imaging.storage.cache.mock;

import java.net.URI;
import java.util.Collection;

import gov.va.med.imaging.storage.cache.*;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;
import gov.va.med.imaging.storage.cache.exceptions.CacheStateException;
import gov.va.med.imaging.storage.cache.exceptions.RegionInitializationException;
import gov.va.med.imaging.storage.cache.memento.CacheMemento;
import gov.va.med.imaging.storage.cache.memento.RegionMemento;

/**
 * @author        DNS
 *
 */
public class MockCache 
implements Cache
{
	private Boolean enabled = Boolean.TRUE;
	private Boolean initialized = Boolean.TRUE;
	
	public static MockCache create()
	{
		return new MockCache();
	}
	
	
	public Boolean isEnabled()
	{
		return enabled;
	}

	public Boolean isInitialized()
	{
		return initialized;
	}
	public void setEnabled(Boolean enabled) 
	throws CacheException
	{
		this.enabled = enabled;
	}

	public void setInitialized(Boolean initialized) 
	throws CacheException
	{
		this.initialized = initialized;
	}

	public String getLocationPath()
	{
		return null;
	}

	public String getLocationProtocol()
	{
		return null;
	}

	public URI getLocationUri()
	{
		return null;
	}

	public String getName()
	{
		return null;
	}
	
	public EvictionTimer getEvictionTimer()
	{
		return null;
	}

	// =================================================================================================================================
	// Eviction Strategies
	// =================================================================================================================================
	public void addEvictionStrategies(Collection<? extends EvictionStrategy> evictionStrategies) 
	throws CacheStateException
	{
	}

	public void addEvictionStrategy(EvictionStrategy evictionStrategy) 
	throws CacheStateException
	{
	}

	public Collection<? extends EvictionStrategy> getEvictionStrategies()
	{
		return null;
	}

	public EvictionStrategy getEvictionStrategy(String name)
	{
		return null;
	}
	
	// =================================================================================================================================
	// Region 
	// =================================================================================================================================
	public Region createRegion(String name, String[] evictionStrategyNames) 
	throws RegionInitializationException
	{
		return null;
	}

	public Region createRegion(RegionMemento regionMemento) 
	throws RegionInitializationException
	{
		return null;
	}

	public void addRegion(Region region) 
	throws CacheException
	{

	}

	public void addRegions(Collection<? extends Region> regions) 
	throws CacheException
	{

	}

	public Region getRegion(String string)
	{
		return null;
	}

	public Collection<? extends Region> getRegions()
	{
		return null;
	}
	
	// =================================================================================================================================
	// Instances
	// =================================================================================================================================
	public void clear() 
	throws CacheException
	{

	}

	public CacheMemento createMemento()
	{
		return null;
	}



	public Instance getInstance(String regionName, String[] group, String key) 
	throws CacheException
	{
		return null;
	}

	public void deleteInstance(String regionName, String[] group, String key) 
	throws CacheException
	{
		return;
	}
	
	public InstanceByteChannelFactory<?> getInstanceByteChannelFactory()
	{
		return null;
	}

	public Instance getOrCreateInstance(String regionName, String[] group, String key) 
	throws CacheException
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Cache#registerCacheStructureChangeListener(gov.va.med.imaging.storage.cache.CacheStructureChangeListener)
	 */
	public void registerCacheStructureChangeListener(CacheStructureChangeListener listener)
	{
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.Cache#unregisterCacheStructureChangeListener(gov.va.med.imaging.storage.cache.CacheStructureChangeListener)
	 */
	public void unregisterCacheStructureChangeListener(CacheStructureChangeListener listener)
	{
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.storage.cache.CacheLifecycleListener#cacheLifecycleEvent(gov.va.med.imaging.storage.cache.CacheLifecycleEvent)
	 */
	public void cacheLifecycleEvent(CacheLifecycleEvent event) throws CacheStateException
	{
	}

}
