/**
 * 
 */
package gov.va.med.imaging.storage.cache.impl;

import gov.va.med.imaging.storage.cache.Instance;
import gov.va.med.imaging.storage.cache.exceptions.CacheException;

/**
 * @author        DNS
 *
 * This class adds recursive group name handling for instances as well as groups.
 * Any class that can be a parent of a set of Group and Instance instances should derive from this
 * class.
*/
public abstract class RecursiveGroupAndInstanceParent 
extends RecursiveGroupParent
{
	/**
	 * 
	 */
	public RecursiveGroupAndInstanceParent()
	{
	}

	// ========================================================================================================
	// Abstract methods bind this class to a persistence mechanism
	// ========================================================================================================
	
	/**
	 * 
	 * @param key
	 * @return
	 * @throws CacheException
	 */
	public abstract Instance getOrCreateChildInstance(String key) 
	throws CacheException;

	/**
	 * 
	 * @param key
	 * @return
	 * @throws CacheException
	 */
	public abstract Instance getChildInstance(String key) 
	throws CacheException;

	/**
	 * 
	 * @param key
	 * @throws CacheException
	 */
	public abstract void deleteChildInstance(String key) 
	throws CacheException;

	/**
	 * Get or create an Instance.  The groupName is an ordered array if the
	 * instances ancestor groups, starting from the progeny of this
	 * group.
	 */
	public Instance getOrCreateInstance(String[] groupName, String key) 
	throws CacheException
	{
		return getOrCreateInstance(groupName, key, true); 
	}

	/**
	 * Get an Instance.  The groupName is an ordered array if the
	 * instances ancestor groups, starting from the progeny of this
	 * group.
	 */
	public Instance getInstance(String[] groupName, String key) 
	throws CacheException
	{
		return getOrCreateInstance(groupName, key, false); 
	}
	
	/**
	 * 
	 * @param groupName
	 * @param key
	 * @param allowCreate
	 * @return
	 * @throws CacheException
	 */
	@Override
	public Instance getOrCreateInstance(String[] groupName, String key, boolean allowCreate) 
	throws CacheException
	{
		if(groupName == null || groupName.length == 0)
			return allowCreate ?
				getOrCreateChildInstance(key):
				getChildInstance(key);

		return super.getOrCreateInstance(groupName, key, allowCreate);
	}
	
	/**
	 * 
	 */
	public void deleteInstance(String[] groupName, String key) 
	throws CacheException
	{
		if(groupName == null || groupName.length == 0)
			deleteChildInstance(key);
		else
			super.deleteInstance(groupName, key);
	}
}
