/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author        DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone  DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class ImagingBaseWebFacadeRouterTest
 //extends  gov.va.med.imaging.BaseWebFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public ImagingBaseWebFacadeRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void isSiteAvailable(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetSiteConnectivityStatusCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.enums.SiteConnectivityStatus.class, 
	 				"GetSiteConnectivityStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetSiteConnectivityStatusCommand' in method 'isSiteAvailable' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudyList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyListBySiteCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudyListBySiteCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudyListBySiteCommand' in method 'getPatientStudyList' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudySet(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudySetResultBySiteCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultBySiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudySetResultBySiteCommand' in method 'getPatientStudySet' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudy(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Study.class, 
	 				"GetStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyCommand' in method 'getPatientStudy' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudyWithDeletedImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		 			, boolean includeDeletedImages
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyCommand' and parameters 'gov.va.med.imaging.StudyURN, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Study.class, 
	 				"GetStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class, boolean.class 
		  			},
 					new Object[]{
				 		studyUrn,includeDeletedImages
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyCommand' in method 'getPatientStudyWithDeletedImages' with parameters 'gov.va.med.imaging.StudyURN, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudy(
 			gov.va.med.imaging.BhieStudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyCommand' and parameters 'gov.va.med.imaging.BhieStudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Study.class, 
	 				"GetStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.BhieStudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyCommand' in method 'getPatientStudy' with parameters 'gov.va.med.imaging.BhieStudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void logImageAccessEvent(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImageAccessEventCommand' and parameters 'gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostImageAccessEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  			},
 					new Object[]{
				 		event
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImageAccessEventCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void logImageAccessEventRetryable(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostImageAccessEventRetryableCommand' and parameters 'gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostImageAccessEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  		},
				new Object[]{
			 		event
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostImageAccessEventRetryableCommand' in method 'logImageAccessEventRetryable' with parameters 'gov.va.med.imaging.exchange.ImageAccessLogEvent'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageInformation(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageInformationCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetImageInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class 
		  			},
 					new Object[]{
				 		imagingUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageInformationCommand' in method 'getImageInformation' with parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageInformation(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, boolean includeDeletedImages
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageInformationCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetImageInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, boolean.class 
		  			},
 					new Object[]{
				 		imagingUrn,includeDeletedImages
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageInformationCommand' in method 'getImageInformation' with parameters 'gov.va.med.imaging.AbstractImagingURN, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageSystemGlobalNode(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageSystemGlobalNodeCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetImageSystemGlobalNodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class 
		  			},
 					new Object[]{
				 		imagingUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageSystemGlobalNodeCommand' in method 'getImageSystemGlobalNode' with parameters 'gov.va.med.imaging.AbstractImagingURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getImageDevFields(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, java.lang.String flags
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageDevFieldsCommand' and parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetImageDevFieldsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		imagingUrn,flags
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageDevFieldsCommand' in method 'getImageDevFields' with parameters 'gov.va.med.imaging.AbstractImagingURN, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getInstanceByImageURN(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Long.class, 
	 				"GetInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,requestedFormatQuality,outStream,metadataCallback
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetInstanceByImageUrnCommand' in method 'getInstanceByImageURN' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchPatientStudyList(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatList
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PrefetchPatientStudyListCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PrefetchPatientStudyListCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,studyFilter,imageFormatList
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PrefetchPatientStudyListCommand' in method 'prefetchPatientStudyList' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTxtFileByImageURN(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataNotification
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageTextCommand' and parameters 'gov.va.med.imaging.ImageURN, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetImageTextCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,outStream,metadataNotification
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageTextCommand' in method 'getTxtFileByImageURN' with parameters 'gov.va.med.imaging.ImageURN, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTxtFileByImageURNAsChild(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataNotification
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetImageTextCommand' and parameters 'gov.va.med.imaging.ImageURN, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetImageTextCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,outStream,metadataNotification
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetImageTextCommand' in method 'getTxtFileByImageURNAsChild' with parameters 'gov.va.med.imaging.ImageURN, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientIdentificationImage(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientIdentificationImageCommand' and parameters 'gov.va.med.PatientIdentifier, gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.io.InputStream.class, 
	 				"GetPatientIdentificationImageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		patientIdentifier,routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientIdentificationImageCommand' in method 'getPatientIdentificationImage' with parameters 'gov.va.med.PatientIdentifier, gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Long.class, 
	 				"GetExamInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream,requestedFormatQuality
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamInstanceByImageUrnCommand' in method 'getExamInstanceByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void headInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'HeadInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ImageMetadata.class, 
	 				"HeadInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,requestedFormatQuality
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'HeadInstanceByImageUrnCommand' in method 'headInstanceByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void headInstanceByImageUrnVerbose(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 			, java.io.OutputStream outStream
 		 			, boolean forceDatasourceAccess
 		 			, boolean forceSizeCalculation
 		 			, boolean allowCaching
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'HeadInstanceByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList, java.io.OutputStream, boolean, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ImageMetadata.class, 
	 				"HeadInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class, java.io.OutputStream.class, boolean.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList,outStream,forceDatasourceAccess,forceSizeCalculation,allowCaching
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'HeadInstanceByImageUrnCommand' in method 'headInstanceByImageUrnVerbose' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.exchange.business.ImageFormatQualityList, java.io.OutputStream, boolean, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientShallowStudyList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetShallowStudyListBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetShallowStudyListBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetShallowStudyListBySiteNumberCommand' in method 'getPatientShallowStudyList' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientShallowStudySetResult(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetShallowStudySetResultBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetShallowStudySetResultBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetShallowStudySetResultBySiteNumberCommand' in method 'getPatientShallowStudySetResult' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientShallowStudyWithReportList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetShallowStudyListWithReportBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetShallowStudyListWithReportBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetShallowStudyListWithReportBySiteNumberCommand' in method 'getPatientShallowStudyWithReportList' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientShallowStudySetWithReport(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetShallowStudySetWithReportBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetShallowStudySetWithReportBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetShallowStudySetWithReportBySiteNumberCommand' in method 'getPatientShallowStudySetWithReport' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentSetListCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.documents.DocumentSet.class, 
 				"GetDocumentSetListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
	  			},
				new Object[]{
			 		routingToken,documentFilter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDocumentSetListCommand' in method 'getDocumentSetList' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetResult(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentSetResultForPatientCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,documentFilter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentSetResultForPatientCommand' in method 'getDocumentSetResult' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetResultFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentSetResultBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,filter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentSetResultBySiteNumberCommand' in method 'getDocumentSetResultFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentSetListBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentSetListBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.documents.DocumentSet.class, 
 				"GetDocumentSetListBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
	  			},
				new Object[]{
			 		routingToken,documentFilter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDocumentSetListBySiteNumberCommand' in method 'getDocumentSetListBySiteNumber' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.DocumentFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocument(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentCommand' and parameters 'gov.va.med.GlobalArtifactIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class 
		  			},
 					new Object[]{
				 		documentIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentCommand' in method 'getDocument' with parameters 'gov.va.med.GlobalArtifactIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocument(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentCommand' and parameters 'gov.va.med.GlobalArtifactIdentifier, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		documentIdentifier,imageMetadataNotification
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentCommand' in method 'getDocument' with parameters 'gov.va.med.GlobalArtifactIdentifier, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntries(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.util.Date startDate
 		 			, java.util.Date endDate
 		 			, gov.va.med.imaging.exchange.enums.ImageQuality imageQuality
 		 			, java.lang.String user
 		 			, java.lang.String modality
 		 			, gov.va.med.imaging.exchange.enums.DatasourceProtocol datasourceProtocol
 		 			, java.lang.String errorMessage
 		 			, java.lang.String imageUrn
 		 			, java.lang.String transactionId
 		 			, java.lang.Boolean forward
 		 			, java.lang.Integer startIndex
 		 			, java.lang.Integer endIndex
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetTransactionLogEntriesCommand' and parameters 'gov.va.med.imaging.access.TransactionLogWriter, java.util.Date, java.util.Date, gov.va.med.imaging.exchange.enums.ImageQuality, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.enums.DatasourceProtocol, java.lang.String, java.lang.String, java.lang.String, java.lang.Boolean, java.lang.Integer, java.lang.Integer'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.util.Date.class, java.util.Date.class, gov.va.med.imaging.exchange.enums.ImageQuality.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.enums.DatasourceProtocol.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Integer.class, java.lang.Integer.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,startDate,endDate,imageQuality,user,modality,datasourceProtocol,errorMessage,imageUrn,transactionId,forward,startIndex,endIndex
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetTransactionLogEntriesCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileByImageUrnCommand' in method 'getExamTextFileByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileByImageUrnAsChild(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileByImageUrnCommand' in method 'getExamTextFileByImageUrnAsChild' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudyWithImagesList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyListWithImagesCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudyListWithImagesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetStudyListWithImagesCommand' in method 'getPatientStudyWithImagesList' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientStudySetResultWithImages(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudySetResultWithImagesBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultWithImagesBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudySetResultWithImagesBySiteNumberCommand' in method 'getPatientStudySetResultWithImages' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postPassthroughMethod(
 			gov.va.med.RoutingToken routingTokenr
 		 			, gov.va.med.imaging.exchange.business.PassthroughInputMethod inputMethod
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPassthroughMethodCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.PassthroughInputMethod'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"PostPassthroughMethodCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.PassthroughInputMethod.class 
		  			},
 					new Object[]{
				 		routingTokenr,inputMethod
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPassthroughMethodCommand' in method 'postPassthroughMethod' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.PassthroughInputMethod'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceByImageUrnNotFromCache(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamInstanceByImageUrnNotCachedCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Long.class, 
	 				"GetExamInstanceByImageUrnNotCachedCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream,requestedFormatQuality
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamInstanceByImageUrnNotCachedCommand' in method 'getExamInstanceByImageUrnNotFromCache' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamInstanceFromCacheByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamInstanceFromCacheByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Long.class, 
	 				"GetExamInstanceFromCacheByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream,requestedFormatQuality
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamInstanceFromCacheByImageUrnCommand' in method 'getExamInstanceFromCacheByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream, gov.va.med.imaging.exchange.business.ImageFormatQualityList'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultWithImagesForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudySetResultWithImagesForPatientCommand' and parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultWithImagesForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudySetResultWithImagesForPatientCommand' in method 'getStudySetResultWithImagesForPatient' with parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudySetResultForPatientCommand' and parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudySetResultForPatientCommand' in method 'getStudySetResultForPatient' with parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudySetResultWithReportsForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudySetResultWithReportForPatientCommand' and parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultWithReportForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudySetResultWithReportForPatientCommand' in method 'getStudySetResultWithReportsForPatient' with parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getShallowStudySetResultForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetShallowStudySetResultForPatientCommand' and parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetShallowStudySetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetShallowStudySetResultForPatientCommand' in method 'getShallowStudySetResultForPatient' with parameters 'gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getShallowArtifactResultsForPatientFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyOnlyArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyOnlyArtifactResultsBySiteNumberCommand' in method 'getShallowArtifactResultsForPatientFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getStudyWithReportArtifactResultsForPatientFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetStudyWithReportArtifactResultsBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithReportArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetStudyWithReportArtifactResultsBySiteNumberCommand' in method 'getStudyWithReportArtifactResultsForPatientFromSite' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, gov.va.med.imaging.exchange.business.StudyFilter, boolean, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDocumentStreamed(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDocumentStreamCommand' and parameters 'gov.va.med.GlobalArtifactIdentifier, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Long.class, 
	 				"GetDocumentStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		documentIdentifier,outStream,imageMetadataNotification
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetDocumentStreamCommand' in method 'getDocumentStreamed' with parameters 'gov.va.med.GlobalArtifactIdentifier, java.io.OutputStream, gov.va.med.imaging.core.interfaces.ImageMetadataNotification'.");
 		}

 }