/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone ( DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class ImagingBaseWebFacadeRouterImpl
 extends  gov.va.med.imaging.BaseWebFacadeRouterImpl 
 implements ImagingBaseWebFacadeRouter
 {
	private static ImagingBaseWebFacadeRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized ImagingBaseWebFacadeRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new ImagingBaseWebFacadeRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected ImagingBaseWebFacadeRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.enums.SiteConnectivityStatus isSiteAvailable(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.enums.SiteConnectivityStatus> command = (Command<gov.va.med.imaging.exchange.enums.SiteConnectivityStatus>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.enums.SiteConnectivityStatus.class, 
	 				"GetSiteConnectivityStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetSiteConnectivityStatusCommand");
		
      
        gov.va.med.imaging.exchange.enums.SiteConnectivityStatus commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.Study> getPatientStudyList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudyListBySiteCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetStudyListBySiteCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.Study> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getPatientStudySet(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultBySiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudySetResultBySiteCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.Study getPatientStudy(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.Study> command = (Command<gov.va.med.imaging.exchange.business.Study>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.Study.class, 
	 				"GetStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyCommand");
		
      
        gov.va.med.imaging.exchange.business.Study commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.Study getPatientStudyWithDeletedImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		 			, boolean includeDeletedImages
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.Study> command = (Command<gov.va.med.imaging.exchange.business.Study>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.Study.class, 
	 				"GetStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class, boolean.class 
		  			},
 					new Object[]{
				 		studyUrn,includeDeletedImages
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyCommand");
		
      
        gov.va.med.imaging.exchange.business.Study commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.Study getPatientStudy(
 			gov.va.med.imaging.BhieStudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.Study> command = (Command<gov.va.med.imaging.exchange.business.Study>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.Study.class, 
	 				"GetStudyCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.BhieStudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyCommand");
		
      
        gov.va.med.imaging.exchange.business.Study commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void logImageAccessEvent(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostImageAccessEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  			},
 					new Object[]{
				 		event
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostImageAccessEventCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void logImageAccessEventRetryable(
 			gov.va.med.imaging.exchange.ImageAccessLogEvent event
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostImageAccessEventRetryableCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.exchange.ImageAccessLogEvent.class 
		  		},
				new Object[]{
			 		event
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getImageInformation(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetImageInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class 
		  			},
 					new Object[]{
				 		imagingUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageInformationCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getImageInformation(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, boolean includeDeletedImages
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetImageInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, boolean.class 
		  			},
 					new Object[]{
				 		imagingUrn,includeDeletedImages
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageInformationCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getImageSystemGlobalNode(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetImageSystemGlobalNodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class 
		  			},
 					new Object[]{
				 		imagingUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageSystemGlobalNodeCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getImageDevFields(
 			gov.va.med.imaging.AbstractImagingURN imagingUrn
 		 			, java.lang.String flags
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetImageDevFieldsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.AbstractImagingURN.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		imagingUrn,flags
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageDevFieldsCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Long getInstanceByImageURN(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Long> command = (Command<java.lang.Long>)getCommandFactory().createCommand(
	 				 java.lang.Long.class, 
	 				"GetInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,requestedFormatQuality,outStream,metadataCallback
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetInstanceByImageUrnCommand");
		
      
        java.lang.Long commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchPatientStudyList(
 			gov.va.med.RoutingToken routingToken
 			, gov.va.med.PatientIdentifier patientIdentifier
 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatList
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PrefetchPatientStudyListCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  		},
				new Object[]{
			 		routingToken,patientIdentifier,studyFilter,imageFormatList
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public int getTxtFileByImageURN(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataNotification
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetImageTextCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,outStream,metadataNotification
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageTextCommand");
		
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public int getTxtFileByImageURNAsChild(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataNotification
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetImageTextCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		imageUrn,outStream,metadataNotification
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetImageTextCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.io.InputStream getPatientIdentificationImage(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.io.InputStream> command = (Command<java.io.InputStream>)getCommandFactory().createCommand(
	 				 java.io.InputStream.class, 
	 				"GetPatientIdentificationImageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		patientIdentifier,routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientIdentificationImageCommand");
		
      
        java.io.InputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Long getExamInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Long> command = (Command<java.lang.Long>)getCommandFactory().createCommand(
	 				 java.lang.Long.class, 
	 				"GetExamInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream,requestedFormatQuality
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamInstanceByImageUrnCommand");
		
      
        java.lang.Long commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ImageMetadata headInstanceByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ImageMetadata> command = (Command<gov.va.med.imaging.exchange.business.ImageMetadata>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ImageMetadata.class, 
	 				"HeadInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,requestedFormatQuality
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("HeadInstanceByImageUrnCommand");
		
      
        gov.va.med.imaging.exchange.business.ImageMetadata commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ImageMetadata headInstanceByImageUrnVerbose(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList imageFormatQualityList
 		 			, java.io.OutputStream outStream
 		 			, boolean forceDatasourceAccess
 		 			, boolean forceSizeCalculation
 		 			, boolean allowCaching
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ImageMetadata> command = (Command<gov.va.med.imaging.exchange.business.ImageMetadata>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ImageMetadata.class, 
	 				"HeadInstanceByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class, java.io.OutputStream.class, boolean.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		imageUrn,imageFormatQualityList,outStream,forceDatasourceAccess,forceSizeCalculation,allowCaching
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("HeadInstanceByImageUrnCommand");
		
      
        gov.va.med.imaging.exchange.business.ImageMetadata commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.Study> getPatientShallowStudyList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetShallowStudyListBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetShallowStudyListBySiteNumberCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.Study> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getPatientShallowStudySetResult(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetShallowStudySetResultBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetShallowStudySetResultBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.Study> getPatientShallowStudyWithReportList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetShallowStudyListWithReportBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetShallowStudyListWithReportBySiteNumberCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.Study> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getPatientShallowStudySetWithReport(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetShallowStudySetWithReportBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetShallowStudySetWithReportBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.documents.DocumentSet> getDocumentSetList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.documents.DocumentSet.class, 
 				"GetDocumentSetListCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
	  			},
				new Object[]{
			 		routingToken,documentFilter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDocumentSetListCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.documents.DocumentSet> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentSetResult getDocumentSetResult(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,documentFilter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentSetResultForPatientCommand");
		
      
        gov.va.med.imaging.exchange.business.documents.DocumentSetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentSetResult getDocumentSetResultFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentSetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentSetResult.class, 
	 				"GetDocumentSetResultBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
		  			},
 					new Object[]{
				 		routingToken,filter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentSetResultBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.documents.DocumentSetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.documents.DocumentSet> getDocumentSetListBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.DocumentFilter documentFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.documents.DocumentSet.class, 
 				"GetDocumentSetListBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.DocumentFilter.class 
	  			},
				new Object[]{
			 		routingToken,documentFilter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetDocumentSetListBySiteNumberCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.documents.DocumentSet> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult getDocument(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class 
		  			},
 					new Object[]{
				 		documentIdentifier
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentCommand");
		
      
        gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult getDocument(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult> command = (Command<gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult.class, 
	 				"GetDocumentCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		documentIdentifier,imageMetadataNotification
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentCommand");
		
      
        gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getTransactionLogEntries(
 			gov.va.med.imaging.access.TransactionLogWriter transactionLogWriter
 		 			, java.util.Date startDate
 		 			, java.util.Date endDate
 		 			, gov.va.med.imaging.exchange.enums.ImageQuality imageQuality
 		 			, java.lang.String user
 		 			, java.lang.String modality
 		 			, gov.va.med.imaging.exchange.enums.DatasourceProtocol datasourceProtocol
 		 			, java.lang.String errorMessage
 		 			, java.lang.String imageUrn
 		 			, java.lang.String transactionId
 		 			, java.lang.Boolean forward
 		 			, java.lang.Integer startIndex
 		 			, java.lang.Integer endIndex
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"GetTransactionLogEntriesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.access.TransactionLogWriter.class, java.util.Date.class, java.util.Date.class, gov.va.med.imaging.exchange.enums.ImageQuality.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.enums.DatasourceProtocol.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Integer.class, java.lang.Integer.class 
		  			},
 					new Object[]{
				 		transactionLogWriter,startDate,endDate,imageQuality,user,modality,datasourceProtocol,errorMessage,imageUrn,transactionId,forward,startIndex,endIndex
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetTransactionLogEntriesCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileByImageUrnCommand");
		
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getExamTextFileByImageUrnAsChild(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileByImageUrnCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.Study> getPatientStudyWithImagesList(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Study.class, 
 				"GetStudyListWithImagesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,filter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetStudyListWithImagesCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.Study> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getPatientStudySetResultWithImages(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultWithImagesBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudySetResultWithImagesBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String postPassthroughMethod(
 			gov.va.med.RoutingToken routingTokenr
 		 			, gov.va.med.imaging.exchange.business.PassthroughInputMethod inputMethod
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"PostPassthroughMethodCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.PassthroughInputMethod.class 
		  			},
 					new Object[]{
				 		routingTokenr,inputMethod
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPassthroughMethodCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Long getExamInstanceByImageUrnNotFromCache(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Long> command = (Command<java.lang.Long>)getCommandFactory().createCommand(
	 				 java.lang.Long.class, 
	 				"GetExamInstanceByImageUrnNotCachedCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream,requestedFormatQuality
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamInstanceByImageUrnNotCachedCommand");
		
      
        java.lang.Long commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Long getExamInstanceFromCacheByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.exchange.business.ImageFormatQualityList requestedFormatQuality
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Long> command = (Command<java.lang.Long>)getCommandFactory().createCommand(
	 				 java.lang.Long.class, 
	 				"GetExamInstanceFromCacheByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class, gov.va.med.imaging.exchange.business.ImageFormatQualityList.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream,requestedFormatQuality
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamInstanceFromCacheByImageUrnCommand");
		
      
        java.lang.Long commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getStudySetResultWithImagesForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultWithImagesForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudySetResultWithImagesForPatientCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getStudySetResultForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudySetResultForPatientCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getStudySetResultWithReportsForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetStudySetResultWithReportForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudySetResultWithReportForPatientCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.StudySetResult getShallowStudySetResultForPatient(
 			gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter studyFilter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.StudySetResult> command = (Command<gov.va.med.imaging.exchange.business.StudySetResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.StudySetResult.class, 
	 				"GetShallowStudySetResultForPatientCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class 
		  			},
 					new Object[]{
				 		patientIdentifier,studyFilter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetShallowStudySetResultForPatientCommand");
		
      
        gov.va.med.imaging.exchange.business.StudySetResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ArtifactResults getShallowArtifactResultsForPatientFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ArtifactResults> command = (Command<gov.va.med.imaging.exchange.business.ArtifactResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyOnlyArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyOnlyArtifactResultsBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.ArtifactResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.ArtifactResults getStudyWithReportArtifactResultsForPatientFromSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, gov.va.med.imaging.exchange.business.StudyFilter filter
 		 			, boolean includeRadiology
 		 			, boolean includeDocuments
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.ArtifactResults> command = (Command<gov.va.med.imaging.exchange.business.ArtifactResults>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.ArtifactResults.class, 
	 				"GetStudyWithReportArtifactResultsBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, gov.va.med.imaging.exchange.business.StudyFilter.class, boolean.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier,filter,includeRadiology,includeDocuments
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetStudyWithReportArtifactResultsBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.ArtifactResults commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Long getDocumentStreamed(
 			gov.va.med.GlobalArtifactIdentifier documentIdentifier
 		 			, java.io.OutputStream outStream
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification imageMetadataNotification
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Long> command = (Command<java.lang.Long>)getCommandFactory().createCommand(
	 				 java.lang.Long.class, 
	 				"GetDocumentStreamCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.GlobalArtifactIdentifier.class, java.io.OutputStream.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class 
		  			},
 					new Object[]{
				 		documentIdentifier,outStream,imageMetadataNotification
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetDocumentStreamCommand");
		
      
        java.lang.Long commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }