/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 6, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:         DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone ( DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.imagegear.datasource;

import gov.va.med.imaging.DateUtil;
import gov.va.med.imaging.exchange.TaskScheduler;
import gov.va.med.imaging.imagegear.datasource.configuration.ImageGearConfiguration;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.TimerTask;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/**
 * This periodically runs and purges old merge directories from the disk
 * 
 * @author      DNS
 *
 */
public class ImageGearMergeOutputPurge
extends TimerTask
{
	private final static Logger logger = Logger.getLogger(ImageGearMergeOutputPurge.class);
	private final static long PURGE_DELAY = 1000 * 120; // purge after two minutes
	private final static long PURGE_REFRESH = 1000 * 60 * 60 * 6; // every 6 hours run the purge
	
	private static ImageGearMergeOutputPurge purgeProcess = null;
	public synchronized static void scheduleMergeOutputPurge()
	{
		// only schedule once - the first time
		if(purgeProcess == null)
		{
			logger.info("Scheduling the merge output purge to run in '" + PURGE_DELAY + "' ms, then periodically every '" + PURGE_REFRESH + "' ms.");
			purgeProcess = new ImageGearMergeOutputPurge();
			TaskScheduler.getTaskScheduler().schedule(purgeProcess, 
					PURGE_DELAY, PURGE_REFRESH);
		}
	}
	
	private ImageGearMergeOutputPurge()
	{
		super();
	}

	/* (non-Javadoc)
	 * @see java.util.TimerTask#run()
	 */
	@Override
	public void run()
	{
		runPurge();		
	}
	
	private void runPurge()
	{
		String directoryPath = getImageGearConfiguration().getGroupOutputDirectory(); 
		logger.info("Running purge to remove old merge output directories from '" + directoryPath + "'.");
		File outputDirectory = new File(
				directoryPath);
		if(!outputDirectory.exists())
		{
			logger.warn("Output directory '" + outputDirectory.getAbsolutePath() + "' does not exist, nothing to purge!");			
		}
		else
		{
			File[] directories = outputDirectory.listFiles();
			for(File directory : directories)
			{
				// just to be sure
				if(directory.isDirectory())
				{
					examineAndPurgeDirectory(directory);
				}
			}
		}
	}
	
	private ImageGearConfiguration getImageGearConfiguration()
	{
		return ImageGearDataSourceProvider.getImageGearConfiguration();
	}
	
	private void examineAndPurgeDirectory(File directory)
	{
		//logger.info("Examining directory '" + directory.getName() + "' to determine if should be purged.");
		Date now = new Date();
		long nowInMillseconds = now.getTime();
		long lastModifiedInMillseconds = directory.lastModified();
		long timeIntervalInDays = (nowInMillseconds - lastModifiedInMillseconds)/DateUtil.MILLISECONDS_IN_DAY;
		int retentionDays = getImageGearConfiguration().getMergeOutputDirectoryRetensionDays();
		if(timeIntervalInDays > retentionDays)
		{
			try
			{
				logger.info("Directory '" + directory.getName() + "' is older than '" + retentionDays + "' days, will be purged.");
				FileUtils.deleteDirectory(directory);
			} 
			catch (IOException ioX)
			{
				logger.error("IOException deleting directory '" + directory.getName() + "', " + ioX.getMessage());
			}
			catch(Exception ex)
			{
				logger.error("Exception deleting directory '" + directory.getName() + "', " + ex.getMessage());
			}
		}
	}

}
