/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * @date Sep 7, 2010
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author vhaiswbeckec
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */

package gov.va.med.imaging.ihe;

import java.text.ParseException;
import gov.va.med.imaging.exceptions.OIDFormatException;
import junit.framework.TestCase;

/**
 * @author vhaiswbeckec
 *
 */
public class TestHL7PatientIdentifier
	extends TestCase
{
	public void testParsing() 
	throws OIDFormatException, ParseException
	{
		HL7PatientIdentifier identifier;
		
		identifier = HL7PatientIdentifier.create("d8420442513945d^^^&1.3.6.1.4.1.21367.2005.1.1&ISO");
		assertEquals( "1.3.6.1.4.1.21367.2005.1.1", identifier.getAssigningAuthority().getUniversalID() );
		assertEquals("d8420442513945d", identifier.getPatientId());
		
		assertEquals("d8420442513945d^^^&1.3.6.1.4.1.21367.2005.1.1&ISO", identifier.toString());
	}
}
