package gov.va.med.imaging.terminology.properties;

import gov.va.med.imaging.terminology.ClassifiedValue;
import gov.va.med.imaging.terminology.SchemeTranslationSPI;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.apache.log4j.Logger;

/**
 *
 */
abstract class PropertyFileTranslationService
extends Properties
implements SchemeTranslationSPI
{
	private Logger logger = Logger.getLogger(PropertyFileSchemeTranslationProvider.class);
	
	/**
	 * 
	 * @throws InstantiationException
	 */
	PropertyFileTranslationService() 
	throws InstantiationException
	{
		try
		{
			InputStream inStream = getXmlInputStream();
			if(inStream != null)
				this.loadFromXML(inStream);
			else
			{
				inStream = getInputStream();
				if(inStream != null)
					this.load(inStream);
				else
				{
					String msg = "Derived class '" + this.getClass().getSimpleName() + "' does not return an input stream for initialization.";
					this.logger.error(msg);
					throw new java.lang.InstantiationException(msg);
				}
			}
		}
		catch (InvalidPropertiesFormatException x)
		{
			String msg = "Derived class '" + this.getClass().getSimpleName() + "' references a properties file in an invalid format.";
			this.logger.error(msg);
			throw new java.lang.InstantiationException(msg);
		}
		catch (IOException x)
		{
			String msg = "Derived class '" + this.getClass().getSimpleName() + "' references a properties file that is inaccessible.";
			this.logger.error(msg);
			throw new java.lang.InstantiationException(msg);
		}
	}
	
	protected abstract InputStream getInputStream();
	protected abstract InputStream getXmlInputStream();

	@Override
	public ClassifiedValue[] translate(String sourceCode)
	{
		String rawTranslatedValue = this.getProperty(sourceCode);
		logger.debug("Translating '" + sourceCode + "' => '" + rawTranslatedValue + "'.");
		
		if(rawTranslatedValue == null)
			return new ClassifiedValue[]{new ClassifiedValue(getSourceCodingScheme(), sourceCode)};
		else
		{
			// if the mapping is one to many, then the values will be comma delimited
			String[] translatedValues = rawTranslatedValue.split(",");
			ClassifiedValue[] result = new ClassifiedValue[translatedValues.length];
			
			for(int index=0; index<translatedValues.length; ++index)
				result[index] = 
					new ClassifiedValue(getDestinationCodingScheme(), translatedValues[index]);
			
			return result;
		}
	}
}