/**
 * 
 */
package gov.va.med.imaging.terminology;

import java.io.*;

/**
 * @author  DNS
 *
 */
public class SwapPropertyFileKeyValue
{
	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		if(args.length != 2)
		{
			System.err.println("SwapPropertyFileKeyValue <infile> <outfile>");
			System.exit(-1);
		}
		
		LineNumberReader lineReader = null;
		FileWriter writer = null;
		try
		{
			lineReader = new LineNumberReader( new FileReader(new File(args[0])) );
			File outFile = new File(args[1]);
			if(outFile.exists())
				outFile.delete();
			outFile.createNewFile();
			writer = new FileWriter(outFile);
			
			swapKeyValue(lineReader, writer);
		}
		catch (FileNotFoundException x)
		{
			x.printStackTrace();
			System.exit(-2);
		}
		catch (IOException x)
		{
			x.printStackTrace();
			System.exit(-3);
		}
		finally
		{
			try{lineReader.close();}catch(Throwable t){}
			try{writer.close();}catch(Throwable t){}
		}
		
	}

	/**
	 * @param infile
	 * @param outfile
	 * @throws IOException 
	 */
	private static void swapKeyValue(LineNumberReader lineReader, Writer writer) 
	throws IOException
	{
		String lineSeperator = System.getProperty("line.separator");
		for( String line=lineReader.readLine(); line != null; line = lineReader.readLine() )
		{
			if(line.trim().startsWith("#"))
				writer.write(line);
			else
			{
				String[] parts = line.split("=");
				if(parts.length != 2)
					System.err.println("Line '" + line + "' is not in the expected form and is being ignored.");
				else
				{
					writer.write(parts[1]);
					writer.write('=');
					writer.write(parts[0]);
					writer.write(lineSeperator);
				}
			}
		}
	}

}
