/**
 * 
  Property of ISI Group, LLC
  Date Created: May 13, 2014
  Developer:  Julian Werfel
 */
package gov.va.med.imaging.hydra.commands;

import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.Patient;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.hydra.rest.types.HydraPatientsType;
import gov.va.med.imaging.hydra.rest.types.HydraRestTranslator;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

import java.util.List;
import java.util.Map;

/**
 * @author Julian Werfel
 *
 */
public class GetPatientsCommand
extends AbstractHydraCommand<List<Patient>, HydraPatientsType>
{
	private final String siteId;
	private final String searchText;

	/**
	 * @param methodName
	 */
	public GetPatientsCommand(String siteId, String searchText)
	{
		super("getPatients");
		this.siteId = siteId;
		this.searchText = searchText;
	}

	public String getSiteId()
	{
		return siteId;
	}

	public String getSearchText()
	{
		return searchText;
	}

	@Override
	protected List<Patient> executeRouterCommand()
	throws MethodException, ConnectionException
	{
		try
		{
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(getSiteId());
			return getRouter().getPatientList(getSearchText(), routingToken);
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new MethodException(rtfX);
		}
	}

	@Override
	protected String getMethodParameterValuesString()
	{
		return "searching for [" + getSearchText() + "] from [" + getSiteId() + "]";
	}

	@Override
	protected HydraPatientsType translateRouterResult(List<Patient> routerResult)
	throws TranslationException, MethodException
	{
		return HydraRestTranslator.translatePatients(routerResult);
	}

	@Override
	protected Class<HydraPatientsType> getResultClass()
	{
		return HydraPatientsType.class;
	}

	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		return null;
	}

	@Override
	public Integer getEntriesReturned(HydraPatientsType translatedResult)
	{
		return translatedResult == null ? 0 : translatedResult.getPatient().length;
	}

}
