package gov.va.med.imaging.shared.dicom.dataelement;

import gov.va.med.imaging.dicom.dataset.TransferSyntaxUid;
import gov.va.med.imaging.dicom.dataset.ValueRepresentation;
import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;
import gov.va.med.imaging.dicom.dataset.elements.NativePixelDataElement;
import gov.va.med.imaging.dicom.dictionary.DicomDictionary;
import gov.va.med.imaging.dicom.dictionary.impl.DicomDictionaryFactory;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;
import gov.va.med.imaging.dicom.exceptions.RawPixelInterpretationValuesNotSetException;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactory;
import gov.va.med.imaging.dicom.parser.impl.DataElementFactoryImpl;
import junit.framework.TestCase;

public class DataElement_OWTest extends TestCase
{
	private DicomDictionary dictionary;
	private TransferSyntaxUid transferSyntax;
	private DataElementFactory factory;
	
	@Override
    protected void setUp() throws Exception
    {
	    super.setUp();
	    dictionary = DicomDictionaryFactory.getDefault();
		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN; 
		factory = new DataElementFactoryImpl(dictionary, transferSyntax, false);
    }

	public void testOneBytePixelData() 
	throws InvalidVRModeException, DicomFormatException, RawPixelInterpretationValuesNotSetException
	{
		int width = 1;
		int height = 1;
		byte[] rawPixelData = new byte[]{0x01, 0x00};
		int valueLength = 1;
		
		showSingleFrameSingleFragmentImage(width, height, 8, 8, 7, rawPixelData, valueLength);
	}

	public void testHundredBytePixelData() 
	throws InvalidVRModeException, DicomFormatException, RawPixelInterpretationValuesNotSetException
	{
		int width = 100;
		int height = 100;
		int bytesPerPixel = 2;
		int bitsAllocated = 8;
		int bitsStored = 8;
		int highBit = 7;
		
		byte[] rawPixelData = createTestData(width, height, bitsAllocated, bitsStored, highBit, bytesPerPixel, true);
		
		showSingleFrameSingleFragmentImage(width, height, bitsAllocated, bitsStored, highBit, rawPixelData, rawPixelData.length);
	}
	
	/**
     * @param rawPixelData
     * @param valueLength
     * @throws InvalidVRModeException
     * @throws DicomFormatException
     * @throws RawPixelInterpretationValuesNotSetException
     */
    private void showSingleFrameSingleFragmentImage(
    		int width, int height, 
    		int bitsAllocated, int bitsStored, int highBit, 
    		byte[] rawPixelData, int valueLength) 
    throws InvalidVRModeException, DicomFormatException, RawPixelInterpretationValuesNotSetException
    {
	    DataElement<?> pixelDataElement = 
			factory.createDataElement(DataElementTag.PIXEL_DATA_TAG, ValueRepresentation.OW, valueLength, rawPixelData);
		NativePixelDataElement nativeElement = (NativePixelDataElement)pixelDataElement;
		nativeElement.setNativePixelInterpretationParameters(bitsAllocated, bitsStored, highBit, width, height);
		//List<BufferedImage> frames = nativeElement.getBufferedImages();
		
		//assertNotNull(frames);
		//assertEquals(1, frames.size());
		
		//BufferedImage image = frames.get(0);
		//Dimension imageDimension = new Dimension(image.getWidth(), image.getHeight());
    }

    /**
     * 
     * @param length
     * @param byteOriented
     * @return
     */
    private byte[] createTestData(
    		int width, 
    		int height, 
    		int bitsAllocated,
    		int bitsStored,
    		int highBit,
    		int wordSizeInBytes,
    		boolean zeroFillUnusedBits)
    {
    	byte[] result = new byte[width * height * wordSizeInBytes];

    	for(int rowIndex=0; rowIndex<height; ++rowIndex)
    	{
    		int rowOffset = rowIndex * width * wordSizeInBytes;
    		
    		for(int columnIndex=0; columnIndex<width; ++columnIndex)
    		{
    			int columnOffset = columnIndex * wordSizeInBytes;
    			
    	    	byte[] word = new byte[wordSizeInBytes];
	    		for(int byteIndex=0; byteIndex < wordSizeInBytes; ++byteIndex)
	    		{
	    			word[byteIndex] = (byte)0x80;
	    		}
	    		System.arraycopy(word, 0, result, rowOffset + columnOffset, word.length);
    		}
    	}
    	return result;
    }
    
	@Override
    protected void tearDown() throws Exception
    {
	    super.tearDown();
    }

}
