package gov.va.med.imaging.hi5.shared;

import static org.junit.Assert.*;
import junit.framework.Assert;

import org.junit.Test;

public class TestArrayConversion
{
    @Test
    public void testByteArrayToIntegerArray()
    {
        byte[] stimulus = new byte[]{1,2,3,4,5,6,7,8,9,10};
        
    }

    @Test
    public void testIntegerArrayToByteArray()
    {
        int[] stimulus = new int[]{1,2,1024,Integer.MAX_VALUE, -1, Integer.MIN_VALUE};
        byte[] byteResult = ArrayConversion.integerArrayToByteArray(stimulus);
        
        Assert.assertEquals(0x00, byteResult[0]);
        Assert.assertEquals(0x00, byteResult[1]);
        Assert.assertEquals(0x00, byteResult[2]);
        Assert.assertEquals(0x01, byteResult[3]);
        
        Assert.assertEquals(0x00, byteResult[4]);
        Assert.assertEquals(0x00, byteResult[5]);
        Assert.assertEquals(0x00, byteResult[6]);
        Assert.assertEquals(0x02, byteResult[7]);
    }

    @Test
    public void testBidirection()
    {
        int[] stimulus = new int[]{1,2,3,4,5,6,7,8,9,10,1024,4096,9192,18384,18385};
        
        byte[] byteResult = ArrayConversion.integerArrayToByteArray(stimulus);
        int[] intResult = ArrayConversion.byteArrayToIntegerArray(byteResult);
        
        for(int index=0; index < stimulus.length; ++index)
            Assert.assertEquals(stimulus[index], intResult[index]);
    }
    
    @Test
    public void testBidirectionLargeNumbers()
    {
        int[] stimulus = new int[]{9192,18384,18385};
        
        byte[] byteResult = ArrayConversion.integerArrayToByteArray(stimulus);
        int[] intResult = ArrayConversion.byteArrayToIntegerArray(byteResult);
        
        for(int index=0; index < stimulus.length; ++index)
            Assert.assertEquals(stimulus[index], intResult[index]);
    }
    
    @Test
    public void testBidirectionRandomValues()
    {
        int[] stimulus = createRandomStimulus(1000, 0, Integer.MAX_VALUE);
        
        byte[] byteResult = ArrayConversion.integerArrayToByteArray(stimulus);
        int[] intResult = ArrayConversion.byteArrayToIntegerArray(byteResult);
        
        for(int index=0; index < stimulus.length; ++index)
            Assert.assertEquals(stimulus[index], intResult[index]);
    }

    /**
     * 
     * @param size
     * @param minimum
     * @param maximum
     * @return
     */
    private int[] createRandomStimulus(int size, int minimum, int maximum)
    {
        int[] result = new int[size];
        for(int index = 0; index < size; ++index)
            result[index] = (int)(Math.random() * (maximum - minimum)) + minimum;
        
        return result;
    }
}
