package gov.va.med.imaging.hi5.client;

import static org.junit.Assert.*;
import junit.framework.Assert;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.google.gwt.touch.client.Point;

public class TestAffineTransform
{
    ImageStatistics imageStats;
    AffineTransform transform;
    
    @Before
    public void setUp() 
    throws Exception
    {
        imageStats = new ImageStatistics(256, 256, (1 << 16)-1, (1 << 8) - 1, 64, 128, 255, 0, new int[]{});
        transform = new AffineTransform(imageStats);
    }

    @After
    public void tearDown() 
    throws Exception
    {
        imageStats = null;
        transform = null;
    }

    @Test
    public void testFlip()
    {
        transform.flip();
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(-1.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

    @Test
    public void testMirror()
    {
        transform.mirror();
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(-1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

    @Test
    public void testRevert()
    {
        transform.mirror();
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(-1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }
    
    @Test
    public void testSetScaleDouble()
    {
        transform.setScale(2.0);
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(2.0, transformedPoint.getX());
        Assert.assertEquals(2.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

    @Test
    public void testScaleDouble()
    {
        transform.setScale(2.0);
        transform.scale(2.0);
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(4.0, transformedPoint.getX());
        Assert.assertEquals(4.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

    @Test
    public void testSetScaleDoubleDouble()
    {
        transform.setScale(2.0, 3.0);
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(2.0, transformedPoint.getX());
        Assert.assertEquals(3.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

    @Test
    public void testScaleDoubleDouble()
    {
        transform.setScale(2.0, 3.0);
        transform.scale(2.0, 3.0);
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(4.0, transformedPoint.getX());
        Assert.assertEquals(9.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

    @Test
    public void testRotate()
    {
        transform.rotate(Math.PI/2);
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(-1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
        
        transform.rotate(Math.PI/2);
        transformedPoint = transform.transformPoint(transformedPoint);
        Assert.assertEquals(-1.0, transformedPoint.getX());
        Assert.assertEquals(-1.0, transformedPoint.getY());
        
        transform.rotate(Math.PI/2);
        transformedPoint = transform.transformPoint(transformedPoint);
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(-1.0, transformedPoint.getY());
        
        transform.rotate(Math.PI/2);
        transformedPoint = transform.transformPoint(transformedPoint);
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

    @Test
    public void testSetRotate()
    {
        transform.rotate(Math.PI/2);
        Point transformedPoint;
        
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(-1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
        
        transform.setRotate(0);
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
        
        transform.revert();
        transformedPoint = transform.transformPoint(new Point(1.0, 1.0));
        Assert.assertEquals(1.0, transformedPoint.getX());
        Assert.assertEquals(1.0, transformedPoint.getY());
    }

}
