package gov.va.med.imaging.dicom.dicomviewer;

import gov.va.med.imaging.dicom.dictionary.DicomDictionary;
import gov.va.med.imaging.dicom.dictionary.impl.DicomDictionaryFactory;
import gov.va.med.imaging.dicom.dictionary.impl.DicomDictionaryUtility;
import junit.framework.TestCase;

public class TestDicomDictionary extends TestCase
{
	private DicomDictionary dicomDictionary;
	
	protected void setUp() throws Exception
	{
		super.setUp();
		dicomDictionary = DicomDictionaryFactory.getDefault();
	}

	public void testGetByElementIntInt()
	{
		assertNotNull( DicomDictionaryUtility.getByElementKey(dicomDictionary, 0, 0) );
	}
	
	public void testGetByElementString()
	{
		assertNotNull( DicomDictionaryUtility.getByElement(dicomDictionary, "(0x0000,0x0000)") );
	}
	
	protected void tearDown() throws Exception
	{
		dicomDictionary = null;
		super.tearDown();
	}

}
