package gov.va.med.imaging.dicom;

import gov.va.med.imaging.dicom.dataset.TransferSyntaxUid;
import gov.va.med.imaging.dicom.parser.impl.TransferSyntaxUidUtility;
import junit.framework.TestCase;

public class TestTransferSyntaxUid extends TestCase
{

	public final void testGetByUid()
	{
		assertTrue(TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.2"));
		assertTrue(TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.1"));
		assertTrue(TransferSyntaxUid.DEFLATED_EXPLICIT_VR_LITTLEENDIAN == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.1.99"));
		assertTrue(TransferSyntaxUid.RAW_IMPLICIT_VR_LITTLEENDIAN == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2"));
		assertTrue(TransferSyntaxUid.JPEG_BASELINE == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.50"));
		assertTrue(TransferSyntaxUid.JPEG_EXTENDED == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.51"));
		assertTrue(TransferSyntaxUid.JPEG_LOSSLESS_NON_HIERARCHICAL == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.57"));
		assertTrue(TransferSyntaxUid.JPEG_LOSSLESS_NON_HIERARCHICAL_FIRST_ORDER == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.70"));
		assertTrue(TransferSyntaxUid.JPEG_LS_LOSSLESS == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.80"));
		assertTrue(TransferSyntaxUid.JPEG_LS_NEAR_LOSSLESS == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.81"));
		assertTrue(TransferSyntaxUid.J2K_PART1_REVERSIBLE == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.90"));
		assertTrue(TransferSyntaxUid.J2K_PART1_IRREVERSIBLE == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.91"));
		assertTrue(TransferSyntaxUid.J2K_PART2_REVERSIBLE == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.92"));
		assertTrue(TransferSyntaxUid.J2K_PART2_IRREVERSIBLE == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.93"));
		assertTrue(TransferSyntaxUid.JPIP_REFERENCED == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.94"));
		assertTrue(TransferSyntaxUid.DEFLATED_JPIP_REFERENCED == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.95"));
		assertTrue(TransferSyntaxUid.MPEG == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.4.100"));
		assertTrue(TransferSyntaxUid.LOSSLESS_RLE == TransferSyntaxUidUtility.getByUid("1.2.840.10008.1.2.5"));
		assertTrue(TransferSyntaxUid.PROPRIETARY == TransferSyntaxUidUtility.getByUid("1.2.3.4"));
		assertTrue(TransferSyntaxUid.PROPRIETARY == TransferSyntaxUidUtility.getByUid(""));
	}

	public final void testMakeUnsignedLongFrom2Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;
		boolean littleEndian = transferSyntax.isLittleEndian();

		byte[] value = new byte[2];
		// in big endian, 0x0201
		value[0] = 0x02;
		value[1] = 0x01;
		assertEquals( 0x0201L, TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, value) );
		
		assertEquals( 0L, TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromLong(transferSyntax.isLittleEndian(), 0L)) );
		assertEquals( 8L, TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromLong(transferSyntax.isLittleEndian(), 8L)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromLong(transferSyntax.isLittleEndian(), (2^16-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
        littleEndian = transferSyntax.isLittleEndian();
		
		// in little endian, 0x0102
		value[0] = 0x02;
		value[1] = 0x01;
		assertEquals( 0x0102L, TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, value) );
		
		assertEquals( 0L, TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromLong(littleEndian, 0L)) );
		assertEquals( 8L, TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromLong(littleEndian, 8L)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedLongFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromLong(littleEndian, (2^16-1))) );
	}

	public final void testMakeUnsignedIntFrom2Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;
        boolean littleEndian = transferSyntax.isLittleEndian();
		
		assertEquals( 0, TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromInt(littleEndian, 0)) );
		assertEquals( 8, TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromInt(littleEndian, 8)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromInt(littleEndian, (2^16-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
		
		assertEquals( 0, TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromInt(littleEndian, 0)) );
		assertEquals( 8, TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromInt(littleEndian, 8)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedIntFrom2Bytes(littleEndian, TransferSyntaxUidUtility.make2BytesFromInt(littleEndian, (2^16-1))) );
	}

	public final void testMakeUnsignedIntFrom4Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;
        boolean littleEndian = transferSyntax.isLittleEndian();
		
		assertEquals( 0, TransferSyntaxUidUtility.makeUnsignedIntFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromInt(littleEndian, 0)) );
		assertEquals( 8, TransferSyntaxUidUtility.makeUnsignedIntFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromInt(littleEndian, 8)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedIntFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromInt(littleEndian, (2^16-1))) );
		assertEquals( (2^24-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^24-1))) );
		assertEquals( (2^32-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^32-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
        littleEndian = transferSyntax.isLittleEndian();
		
		assertEquals( 0, TransferSyntaxUidUtility.makeUnsignedIntFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromInt(littleEndian, 0)) );
		assertEquals( 8, TransferSyntaxUidUtility.makeUnsignedIntFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromInt(littleEndian, 8)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedIntFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromInt(littleEndian, (2^16-1))) );
		assertEquals( (2^24-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^24-1))) );
		assertEquals( (2^32-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^32-1))) );
	}

	public final void testMakeUnsignedLongFrom4Bytes()
	{
		TransferSyntaxUid transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_BIGENDIAN;
        boolean littleEndian = transferSyntax.isLittleEndian();
		
		assertEquals( 0, TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, 0)) );
		assertEquals( 8, TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, 8)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^16-1))) );
		assertEquals( (2^24-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^24-1))) );
		assertEquals( (2^32-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^32-1))) );

		transferSyntax = TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN;
		
		assertEquals( 0, TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, 0)) );
		assertEquals( 8, TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, 8)) );
		assertEquals( (2^16-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^16-1))) );
		assertEquals( (2^24-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^24-1))) );
		assertEquals( (2^32-1), TransferSyntaxUidUtility.makeUnsignedLongFrom4Bytes(littleEndian, TransferSyntaxUidUtility.make4BytesFromLong(littleEndian, (2^32-1))) );
	}
}
