package gov.va.med.imaging.dicom;

import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;
import gov.va.med.imaging.dicom.parser.io.Part10DataSetLoader;

import java.io.InputStream;
import java.util.Iterator;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestDataSetIterator
{
    DataSet dataSet;

    @Before
    public void setUp() throws Exception
    {
        InputStream inStream = this.getClass().getClassLoader()
                .getResourceAsStream("images/brain_001.dcm");
        Part10DataSetLoader loader = null;

        try
        {
            loader = Part10DataSetLoader.load(inStream);
            dataSet = loader.getDataSet();
        } catch (Exception e)
        {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        } finally
        {
            inStream.close();
        }

    }

    @After
    public void tearDown() throws Exception
    {
        dataSet = null;
    }

    @Test
    public void testIterator()
    {
        for (Iterator<DataElement<?>> it = dataSet.iterator(); it
                .hasNext();)
        {
            DataElement<?> dataElement = it.next();

            String key = dataElement.getDataElementTag().toString();
            String value;
            try
            {
                value = dataElement.getValue().toString();
            } catch (ValueRepresentationInterpretationException e1)
            {
                value = e1.getMessage();
            }
            System.out.println("Element " + key + "->" + value);
        }
    }

}
