package gov.va.med.imaging.hi5.shared;

/**
 * Some static classes that convert arrays of primitive numeric types to other primitive numeric
 * types.
 * 
 * @author        DNS
 *
 */
public class ArrayConversion
{
    /**
     * Convert byte array into an int array, assumes big-endian
     * 
     * @param byteData
     * @return
     */
    public static int[] byteArrayToIntegerArray(byte[] byteData)
    {
        int[] result = new int[byteData.length / 4];
        
        for(int intArrayIndex=0; intArrayIndex < result.length; ++intArrayIndex)
        {
            int element = 0;
            for(int byteIndex=3; byteIndex >= 0; --byteIndex)
            {
                int byteValue = byteData[(intArrayIndex * 4) + byteIndex] & 0xFF;
                int bitMask = 0xFF << (8 * (3-byteIndex));
                int placeValue = byteValue << (8 * (3-byteIndex)) & bitMask;
                element += placeValue;
            }
            
            result[intArrayIndex] = element;
        }
        
        return result;
    }

    /**
     * Converts an integer array into a big-endian byte array.
     * 
     * @param byteData
     * @return
     */
    public static byte[] integerArrayToByteArray(int[] intData)
    {
        byte[] result = new byte[intData.length * 4];
        
        // each set of 4 bytes makes an integer
        for(int intArrayIndex=0; intArrayIndex < intData.length; ++intArrayIndex)
            for(int byteIndex=0; byteIndex <= 3; ++byteIndex)
                result[intArrayIndex * 4 + byteIndex] = (byte)( intData[intArrayIndex] >>> ((3 - byteIndex) * 8) & 0x000000FF ); 
        
        return result;
        
    }
}
