package gov.va.med.imaging.hi5.server;

import gov.va.med.imaging.dicom.DicomServiceCreationException;
import gov.va.med.imaging.dicom.DicomServiceProvider;
import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.spi.Part10DataSetParserSPI;
import gov.va.med.imaging.hi5.client.DicomService;
import gov.va.med.imaging.hi5.shared.FieldVerifier;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletException;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class DicomServiceImpl 
extends RemoteServiceServlet 
implements DicomService 
{
    private final DicomServiceProvider dicomServiceProvider = DicomServiceProvider.getSingleton();
    
	@Override
    public DataSet getDataSet(String imageName)
    throws IllegalArgumentException
    {
		if (!FieldVerifier.isValidName(imageName)) 
			// If the input is not valid, throw an IllegalArgumentException back to
			// the client.
			throw new IllegalArgumentException("the image name must be specified and is not.");

		//String serverInfo = getServletContext().getServerInfo();
		//String userAgent = getThreadLocalRequest().getHeader("User-Agent");
		
		return retrieveDicomImage(imageName);
	}

	/**
	 * 
	 * @param imageName
	 * @return
	 * @throws ServletException 
	 */
	private DataSet retrieveDicomImage(String imageName) 
	throws IllegalArgumentException
	{
		InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("images/" + imageName);
		if(inStream != null)
			return retrieveDicomImage(inStream);
		else
			throw new IllegalArgumentException("Image '" + imageName + "' does not exist.");
	}

	/**
	 * 
	 * @param inStream
	 * @return
	 * @throws IllegalArgumentException
	 * @throws ServletException 
	 */
	private DataSet retrieveDicomImage(InputStream inStream)
	throws IllegalArgumentException
	{
        Part10DataSetParserSPI parser = null;
        try
        {
            parser = this.dicomServiceProvider.create(Part10DataSetParserSPI.class);
        } 
        catch (DicomServiceCreationException e1)
        {
            throw new IllegalArgumentException(e1);
        }
        DataSet dicomDataSet = null;

        try
        {
            dicomDataSet = parser.parseInputStreamWithPixels(inStream);
            //Part10DataSetLoader loader = Part10DataSetLoader.load(inStream);
            //dicomDataSet = loader.getDataSet();
            
            return dicomDataSet;
        } 
        catch (Exception e)
        {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        } 
        finally
        {
            try{inStream.close();}
            catch(IOException ioX){}
        }
    }

}
