/**
 * 
 */
package gov.va.med.imaging.hi5.client;

import com.google.gwt.canvas.dom.client.CanvasPixelArray;

/**
 * @author    DNS
 *
 */
public class RGBPixel
{
    public static int RED_OFFSET = 0;
    public static int GREEN_OFFSET = 1;
    public static int BLUE_OFFSET = 2;
    public static int ALPHA_OFFSET = 3;
    public static int PIXEL_STORAGE_SIZE = 4;
    
    private int red = 0x00;
    private int green = 0x00;
    private int blue = 0x00;
    private int alpha = 0xFF;
    
    /**
     * A convenience for creating instances from an int array.
     * The first parameter is the array, the second parameter is the offset to the red value of
     * the pixel.
     * 
     * @param pixelValues
     * @param offset
     */
    public RGBPixel(int[] pixelValues, int offset)
    {
        this.red = pixelValues[offset + RED_OFFSET];
        this.green = pixelValues[offset + GREEN_OFFSET];
        this.blue = pixelValues[offset + BLUE_OFFSET];
        this.alpha = pixelValues[offset + ALPHA_OFFSET];
    }
    
    /**
     * A convenience for creating instances from a CanvasPixelArray array.
     * The first parameter is the array, the second parameter is the offset to the red value of
     * the pixel.
     * 
     * @param pixelValues
     * @param offset
     */
    public RGBPixel(CanvasPixelArray cpa, int offset)
    {
        this.red = cpa.get(offset + RED_OFFSET);
        this.green = cpa.get(offset + GREEN_OFFSET);
        this.blue = cpa.get(offset + BLUE_OFFSET);
        this.alpha = cpa.get(offset + ALPHA_OFFSET);
    }
    
    /**
     * 
     * @param pixelValues
     */
    public RGBPixel(int[] pixelValues)
    {
        if(pixelValues.length == 3 || pixelValues.length == 4)
        {
            this.red = pixelValues[RED_OFFSET];
            this.green = pixelValues[GREEN_OFFSET];
            this.blue = pixelValues[BLUE_OFFSET];
        }
        if(pixelValues.length == 4)
            this.alpha = pixelValues[ALPHA_OFFSET];
    }

    public RGBPixel(int red, int green, int blue)
    {
        this(red, green, blue, 0xFF);
    }

    public RGBPixel(int red, int green, int blue, int alpha)
    {
        super();
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public int getRed()
    {
        return red;
    }

    public void setRed(int red)
    {
        this.red = red;
    }

    public int getGreen()
    {
        return green;
    }

    public void setGreen(int green)
    {
        this.green = green;
    }

    public int getBlue()
    {
        return blue;
    }

    public void setBlue(int blue)
    {
        this.blue = blue;
    }

    public int getAlpha()
    {
        return alpha;
    }

    public void setAlpha(int alpha)
    {
        this.alpha = alpha;
    }
    
    /**
     * Given a CanvasPixelArray and the index to the start of the RED channel,
     * put the RGBA channel values into the CPA.
     * 
     * @param cpa
     * @param index
     */
    public void setValueIn(CanvasPixelArray cpa, int index)
    {
        cpa.set(index + RED_OFFSET, getRed());
        cpa.set(index + GREEN_OFFSET, getGreen());
        cpa.set(index + BLUE_OFFSET, getBlue());
        cpa.set(index + ALPHA_OFFSET, getAlpha());
    }
}
