/**
 * 
 */
package gov.va.med.imaging.hi5.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.smartgwt.client.widgets.toolbar.ToolStrip;
import com.smartgwt.client.widgets.toolbar.ToolStripButton;

/**
 * @author        DNS
 *
 */
public class ImageToolStrip 
extends ToolStrip
{
    private final Hi5 hi5Parent;
    
    private ToolStripButton zoomInButton; 
    private ToolStripButton zoomOutButton; 
    private ToolStripButton revertButton; 
    private ToolStripButton panButton; 
    private ToolStripButton invertButton; 
    private ToolStripButton flipHorizontalButton; 
    private ToolStripButton flipVerticalButton; 
    private ToolStripButton rotateButton; 
    private ToolStripButton testPatternButton; 
    
    public ImageToolStrip(Hi5 hi5Parent)
    {
        super();
        this.hi5Parent = hi5Parent;
        initialize();
    }

    public ImageToolStrip(Hi5 hi5Parent, JavaScriptObject jsObj)
    {
        super(jsObj);
        this.hi5Parent = hi5Parent;
        initialize();
    }

    public Hi5 getHi5Parent()
    {
        return hi5Parent;
    }

    private void initialize()
    {
        this.setID("imageToolStrip");
        
        zoomInButton = 
            new CommandToolStripButton(getHi5Parent().new ZoomInCommand(), "ZoomIn", hi5Parent.getICON_PACKAGE() + "zoom_in.png"); 
        zoomOutButton = 
            new CommandToolStripButton(getHi5Parent().new ZoomOutCommand(), "ZoomOut", hi5Parent.getICON_PACKAGE() + "zoom_out.png"); 
        panButton =  
            new CommandToolStripButton(getHi5Parent().new PanCommand(), "Pan", hi5Parent.getICON_PACKAGE() + "hand_point.png");
        
        invertButton =  
            new CommandToolStripButton(getHi5Parent().new InvertCommand(), "Invert", hi5Parent.getICON_PACKAGE() + "contrast.png"); 
        flipHorizontalButton =  
            new CommandToolStripButton(getHi5Parent().new FlipHorizontalCommand(), "Flip Horizontal", hi5Parent.getICON_PACKAGE() + "flip-horizontal.png"); 
        flipVerticalButton = 
            new CommandToolStripButton(getHi5Parent().new FlipVerticalCommand(), "Flip Vertical", hi5Parent.getICON_PACKAGE() + "flip-vertical.png"); 
        rotateButton = 
            new CommandToolStripButton(getHi5Parent().new RotateClockwiseCommand(), "Rotate", hi5Parent.getICON_PACKAGE() + "audio-knob.png"); 
        revertButton = 
            new CommandToolStripButton(getHi5Parent().new RevertCommand(), "Revert", hi5Parent.getICON_PACKAGE() + "last.png"); 
        
        testPatternButton = 
            new CommandToolStripButton(getHi5Parent().new DrawTestPatternCommand(), "Test", hi5Parent.getICON_PACKAGE() + "last.png"); 
        
        //this.addButton(panButton);
        this.addButton(zoomInButton);
        this.addButton(zoomOutButton);
        
        this.addButton(invertButton);
        this.addButton(flipHorizontalButton);
        this.addButton(flipVerticalButton);
        this.addButton(rotateButton);
        
        this.addButton(revertButton);
        
        //this.addButton(testPatternButton);
    }
}
