package gov.va.med.imaging.hi5.client;

class ImageStatistics
{
    private final int width;
    private final int height;
    private final int grayScaleLevels;
    private final int displayGrayScaleLevels;
    private final double window;
    private final double level;
    private final double maximum;
    private final double minimum;
    private final int[] histogram;
    
    public ImageStatistics(
        int width, int height, 
        int grayScaleLevels, int displayGrayScaleLevels, 
        double window, double level, double maximum, double minimum, int[] histogram)
    {
        super();
        this.width = width;
        this.height = height;
        this.grayScaleLevels = grayScaleLevels;
        this.displayGrayScaleLevels = displayGrayScaleLevels;
        this.window = window;
        this.level = level;
        this.maximum = maximum;
        this.minimum = minimum;
        this.histogram = histogram;
    }
    
    public int getWidth()
    {
        return width;
    }

    public int getHeight()
    {
        return height;
    }

    public int getGrayScaleLevels()
    {
        return grayScaleLevels;
    }

    public int getDisplayGrayScaleLevels()
    {
        return displayGrayScaleLevels;
    }

    public double getWindow()
    {
        return window;
    }
    
    public double getLevel()
    {
        return level;
    }

    public double getMaximum()
    {
        return maximum;
    }

    public double getMinimum()
    {
        return minimum;
    }

    public int[] getHistogram()
    {
        return histogram;
    }
    
    public double getMaximumWindow()
    {
        return getMaximum() - getMinimum();
    }
    
}
