/**
 * 
 */
package gov.va.med.imaging.hi5.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Command;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.toolbar.ToolStrip;
import com.smartgwt.client.widgets.toolbar.ToolStripButton;

/**
 * @author       DNS
 *
 */
public class GenericToolStrip 
extends ToolStrip
{
    private final Hi5 hi5Parent;
    
    private ToolStripButton loadButton; 
    private ToolStripButton helpButton; 
    private ToolStripButton aboutButton; 
    
    public GenericToolStrip(Hi5 hi5Parent)
    {
        super();
        this.hi5Parent = hi5Parent;
        initialize();
    }

    public GenericToolStrip(Hi5 hi5Parent, JavaScriptObject jsObj)
    {
        super(jsObj);
        this.hi5Parent = hi5Parent;
        initialize();
    }

    public Hi5 getHi5Parent()
    {
        return hi5Parent;
    }

    private void initialize()
    {
        this.setID("genericToolStrip");
        
        loadButton = new CommandToolStripButton(getHi5Parent().new LoadCommand(), "Load", hi5Parent.getICON_PACKAGE() + "eye_open.png"); 
        helpButton = new ToolStripButton("Help", hi5Parent.getICON_PACKAGE() + "chat_emoticon.png"); 
        aboutButton = new CommandToolStripButton(getHi5Parent().new ShowBrowserInformationCommand(), "About", hi5Parent.getICON_PACKAGE() + "chat_exclamation.png"); 
        
        this.addButton(loadButton);
        this.addButton(helpButton);
        this.addButton(aboutButton);
    }
    
}
