/**
 * 
 */
package gov.va.med.imaging.hi5.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Command;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.toolbar.ToolStrip;
import com.smartgwt.client.widgets.toolbar.ToolStripButton;

/**
 * @author        DNS
 *
 */
public class ElementToolStrip 
extends ToolStrip
{
    private final Hi5 hi5Parent;
    
    public ElementToolStrip(Hi5 hi5Parent)
    {
        super();
        this.hi5Parent = hi5Parent;
        initialize();
    }

    public ElementToolStrip(Hi5 hi5Parent, JavaScriptObject jsObj)
    {
        super(jsObj);
        this.hi5Parent = hi5Parent;
        initialize();
    }

    public Hi5 getHi5Parent()
    {
        return hi5Parent;
    }

    private void initialize()
    {
        this.setID("elementToolStrip");
        
        ToolStripButton button = null;
        
        button = new ToolStripButton("Find", hi5Parent.getICON_PACKAGE() + "eye_open.png"); 
        button.addClickHandler(new ClickHandler()
        {
            @Override
            public void onClick(ClickEvent event)
            {
                Command command = getHi5Parent().new LoadCommand();
                command.execute();
            }
        });
        this.addButton(button);
    }
    
}
