/**
 * 
 */
package gov.va.med.imaging.hi5.client;

/**
 * @author     DNS
 *
 */
public class DisplayResolution
{
    private static final int DEFAULT_SCREEN_WIDTH = 800;
    private static final int DEFAULT_SCREEN_HEIGHT = 600;
    private static final int DEFAULT_AVAILABLE_SCREEN_WIDTH = 600;
    private static final int DEFAULT_AVAILABLE_SCREEN_HEIGHT = 800;
    private static final int DEFAULT_PIXEL_DEPTH = 8;
    private static final int DEFAULT_COLOR_DEPTH = 8;
    
    private native String getColorDepthVar() /*-{ 
        return $wnd.colorDepth 
    }-*/;
    private native String getPixelDepthVar() /*-{ 
        return $wnd.pixelDepth 
    }-*/;
    private native String getAvailableHeightVar() /*-{ 
        return $wnd.availableHeight 
    }-*/;
    private native String getAvailableWidthVar() /*-{ 
        return $wnd.availableWidth 
    }-*/;
    private native String getScreenHeightVar() /*-{ 
        return $wnd.screenHeight 
    }-*/;
    private native String getScreenWidthVar() /*-{ 
        return $wnd.screenWidth 
    }-*/;
    
    public int getScreenWidth()
    {
        try
        {
            return Integer.parseInt(getScreenWidthVar());
        } 
        catch (NumberFormatException e)
        {
            return DEFAULT_SCREEN_WIDTH;
        }
    }
    public int getScreenHeight()
    {
        try
        {
            return Integer.parseInt(getScreenHeightVar());
        } 
        catch (NumberFormatException e)
        {
            return DEFAULT_SCREEN_HEIGHT;
        }
    }
    public int getColorDepth()
    {
        try
        {
            return Integer.parseInt(getColorDepthVar());
        } 
        catch (NumberFormatException e)
        {
            return DEFAULT_COLOR_DEPTH;
        }
    }
    public int getPixelDepth()
    {
        try
        {
            return Integer.parseInt(getPixelDepthVar());
        } 
        catch (NumberFormatException e)
        {
            return DEFAULT_PIXEL_DEPTH;
        }
    }
    public int getAvailableScreenWidth()
    {
        try
        {
            return Integer.parseInt(getAvailableWidthVar());
        } 
        catch (NumberFormatException e)
        {
            return DEFAULT_AVAILABLE_SCREEN_WIDTH;
        }
    }
    public int getAvailableScreenHeight()
    {
        try
        {
            return Integer.parseInt(getAvailableHeightVar());
        } 
        catch (NumberFormatException e)
        {
            return DEFAULT_AVAILABLE_SCREEN_HEIGHT;
        }
    }
}
