/**
 * 
 */
package gov.va.med.imaging.hi5.client;

import gov.va.med.imaging.dicom.dataset.DataSet;
import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.math.BigDecimal;
import java.util.Iterator;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;

/**
 * @author       DNS
 *
 */
public class DicomDataSetGrid
extends Grid
implements DataSourceEventListener
{
    private final DicomDataSetDataSource dataSource;
    
    /**
     * 
     */
    public DicomDataSetGrid(DicomDataSetDataSource dataSource)
    {
        this.dataSource = dataSource;
        this.dataSource.addDataSourceEventListener(this);
    }

    protected DicomDataSetDataSource getDataSource()
    {
        return dataSource;
    }

    /* (non-Javadoc)
     * @see gov.va.med.imaging.hi5.client.DataSourceEventListener#dataEvent(gov.va.med.imaging.hi5.client.DataSourceEvent)
     */
    @Override
    public void dataEvent(DataSourceEvent event)
    {
        this.removeAllRows();
        if( DataSourceEvent.DataEventType.DATA_NEW_EVENT == event.getDataEventType())
        {
            
            DataSet dataSet = getDataSource().getCurrentDataSet();
            this.resize(dataSet.size(), 2);
            int rowIndex = 0;
            for(Iterator<DataElementTag> dataElementTagIter = dataSet.keyIterator(); dataElementTagIter.hasNext(); )
            {
                DataElementTag tag = dataElementTagIter.next();
                DataElement<?> element = dataSet.get(tag);

                this.setWidget(rowIndex, 0, new HTML(tag.toString()));
                this.setWidget(rowIndex, 1, new HTML( getDisplayValue(element) ) );
                
                ++rowIndex;
            }
        }
        else if( DataSourceEvent.DataEventType.DATA_ERROR_EVENT == event.getDataEventType())
        {
            
        }
    }

    private void removeAllRows()
    {
        this.resizeRows(0);
    }
    
    private String getDisplayValue(DataElement<?> dataElement)
    {
        Object value;
        try
        {
            value = dataElement.getValue();
            
            if(value instanceof String)
                return (String)value;
            else if(value instanceof BigDecimal)
                return ((BigDecimal)value).toString();
            else if(value instanceof Character)
                return Character.toString( ((Character)value) );
            else if(value instanceof Byte)
                return Byte.toString( ((Byte)value) );
            else if(value instanceof Integer)
                return ((Integer)value).toString();
            else if(value instanceof Long)
                return ((Long)value).toString();
            else if(value instanceof Float)
                return ((Float)value).toString();
            else if(value instanceof Double)
                return ((Double)value).toString();
            else
                return value.toString();
        } 
        catch (ValueRepresentationInterpretationException e)
        {
            return e.getMessage();
        }
    }
    
}
