package gov.va.med.imaging.hdigmanagement.web;

import gov.va.med.imaging.GUID;
import gov.va.med.imaging.core.FacadeRouterUtility;
import gov.va.med.imaging.dicom.dcftoolkit.startup.DicomEngineAdapter;
import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.exchange.business.storage.Place;
import gov.va.med.imaging.exchange.business.storage.StorageServerConfiguration;
import gov.va.med.imaging.exchange.business.storage.StorageServerDatabaseConfiguration;
import gov.va.med.imaging.hdigmanagement.HDIGManagementRouter;
import gov.va.med.imaging.health.VixServerHealth;
import gov.va.med.imaging.health.VixServerHealthProperties;
import gov.va.med.imaging.health.VixServerHealthSource;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.servlet.jsp.JspException;

import org.apache.log4j.Logger;

public class VixDicomServerHealthView {

	private final static Logger logger = Logger.getLogger(VixDicomServerHealthView.class);
	
	private final static String InboundAssociations_DicomServiceStats = "_InboundAssociations_DicomServiceStats_";
	private final static String InboundModalityDevices_DicomServiceStats = "_InboundModalityDevices_DicomServiceStats_";
	private final static String InboundSOPClasses_DicomServiceStats = "_InboundSOPClasses_DicomServiceStats_";
	private final static String Port_DicomServiceStats = "_Port_DicomServiceStats_";
	private final static String OutboundAssociations_DicomServiceStats = "_OutboundAssociations_DicomServiceStats_";
	private final static String OutboundObjects_DicomServiceStats = "_OutboundObjects_DicomServiceStats_";
	private final static String InboundObjects_DicomServiceStats = "_InboundObjects_DicomServiceStats_";
	private final static String InboundDimseMessages_DicomServiceStats = "_InboundDimseMessages_DicomServiceStats_";
	private final static String DicomServiceStats = "_DICOMActivity_DicomServiceStats";

	public static VixDicomServerHealthView get()
			throws JspException {
		VixDicomServerHealthView view = null;
		try {
			HDIGManagementRouter router;
			router = FacadeRouterUtility
					.getFacadeRouter(HDIGManagementRouter.class);
			TransactionContextFactory.get().setTransactionId(
					new GUID().toString());
			VixServerHealth health = router
					.getVixServerHealth(VixServerHealthSource.values());
			view = new VixDicomServerHealthView(health);
		} catch (Exception e) {
			throw new JspException(e);
		}
		return view;
	}

	private final VixServerHealth vixHealth;
	private final String serverName;
	private final String jvmStartTime;
	private final String jvmUptime;
	private final String vixVersion;
	private final String dcfVersion;
	private final String dcfLicenseExpirationDate;
	private final String radObjectsToCorrectFromHDIG;
	private final String conObjectsToCorrectFromHDIG;
	private final String dicomCorrectWorkItemCount;
	private final String networkImportWorkItemCount;
	private final String stagedMediaWorkItemCount;
	private final String failedWorkItemCount;
	private final boolean serviceAccountValid;

	private final List<VixInboundDicomAssociation> inboundAssociations;
	private final List<VixInboundDicomModalityDevice> inboundDevices;
	private final List<VixInboundDicomSOPClass> inboundSOPClasses;
	private final List<VixDicomPort> ports;
	private final List<VixInboundDicomDimse> inboundDimses;
	private final List<VixInboundDicomObjects> inboundObjects;
	private final List<VixOutboundDicomAssociation> outboundAssociations;
	private final List<VixOutboundDicomObjects> outboundObjects;
	

	public VixDicomServerHealthView(VixServerHealth vixSiteHealth) {
		super();
		this.vixHealth = vixSiteHealth;

		Map<String, String> properties = this.vixHealth
				.getVixServerHealthProperties();

		this.serverName = properties
				.get(VixServerHealthProperties.VIX_SERVER_HEALTH_VIX_HOSTNAME);
		String jvmStartTimeRaw = properties
				.get(VixServerHealthProperties.VIX_SERVER_HEALTH_VIX_JVM_STARTTIME);
		String jvmUptimeRaw = properties
				.get(VixServerHealthProperties.VIX_SERVER_HEALTH_VIX_JVM_UPTIME);
		vixVersion = properties
				.get(VixServerHealthProperties.VIX_SERVER_HEALTH_VIX_VERSION);

		jvmStartTime = convertMSToTimeString(jvmStartTimeRaw);
		jvmUptime = convertRawUptimeToTimeString(jvmUptimeRaw);
		dcfVersion = properties.get(VixServerHealthProperties.VIX_DCF_VERSION);
		dcfLicenseExpirationDate = properties
				.get(VixServerHealthProperties.VIX_DCF_LICENSE_EXPIRATION_DATE);
		radObjectsToCorrectFromHDIG = properties
				.get(VixServerHealthProperties.VIX_TOTAL_RAD_OBJECTS_TO_CORRECT
						+DicomServiceStats);
		conObjectsToCorrectFromHDIG = properties
				.get(VixServerHealthProperties.VIX_TOTAL_CON_OBJECTS_TO_CORRECT
						+DicomServiceStats);
				
		String accountValid = properties.get(
				VixServerHealthProperties.VIX_SERVICE_ACCOUNT_VALID + DicomServiceStats) + "";
		
		// If the account status property is explicitly set to N, it's not valid. 
		// Otherwise, it is valid.
		serviceAccountValid = !accountValid.toUpperCase().equals("N");
		
		dicomCorrectWorkItemCount = properties.get(
				VixServerHealthProperties.VIX_TOTAL_DICOM_CORRECT_WORK_ITEMS + DicomServiceStats);
		
		networkImportWorkItemCount = properties.get(
				VixServerHealthProperties.VIX_TOTAL_NETWORK_IMPORT_WORK_ITEMS + DicomServiceStats);

		stagedMediaWorkItemCount = properties.get(
				VixServerHealthProperties.VIX_TOTAL_STAGED_MEDIA_WORK_ITEMS + DicomServiceStats);

		failedWorkItemCount = properties.get(
				VixServerHealthProperties.VIX_TOTAL_FAILED_WORK_ITEMS + DicomServiceStats);
		
		inboundAssociations = new ArrayList<VixInboundDicomAssociation>();
		inboundDevices = new ArrayList<VixInboundDicomModalityDevice>();
		inboundSOPClasses = new ArrayList<VixInboundDicomSOPClass>();
		ports = new ArrayList<VixDicomPort>();
		inboundDimses = new ArrayList<VixInboundDicomDimse>();
		inboundObjects = new ArrayList<VixInboundDicomObjects>();
		outboundAssociations = new ArrayList<VixOutboundDicomAssociation>();
		outboundObjects = new ArrayList<VixOutboundDicomObjects>();
		
		fillInboundAssociations(properties);
		fillInboundDevices(properties);
		fillInboundSOPClasses(properties);
		fillPorts(properties);
		fillInboundDimses(properties);
		fillInboundObjects(properties);
		fillOutboundAssociations(properties);
		fillOutboundObjects(properties);
	}

	private String convertMSToTimeString(String time) {
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis(Long.parseLong(time));

		SimpleDateFormat formatter = getDateFormat();
		return formatter.format(c.getTime());
	}

	private String convertRawUptimeToTimeString(String uptimeString) {
		long ms = Long.parseLong(uptimeString);

		StringBuilder sb = new StringBuilder();
		String prefix = "";
		int sec = 1000;
		int min = sec * 60;
		int hour = min * 60;
		int days = hour * 24;

		if (ms > days) {
			long d = (long) (ms / days);
			ms -= d * days;
			sb.append(prefix);
			sb.append(d + " days");
			prefix = ", ";
		}
		if (ms > hour) {
			long d = (long) (ms / hour);
			ms -= d * hour;
			sb.append(prefix);
			sb.append(d + " hours");
			prefix = ", ";
		}
		if (ms > min) {
			long d = (long) (ms / min);
			ms -= d * min;
			sb.append(prefix);
			sb.append(d + " minutes");
			prefix = ", ";
		}
		if (ms > sec) {
			long d = (long) (ms / sec);
			ms -= d * sec;
			sb.append(prefix);
			sb.append(d + " seconds");
			prefix = ", ";
		}
		if (ms > 0) {
			sb.append(prefix);
			sb.append(ms + " ms");
			prefix = ", ";
		}
		return sb.toString();
	}

	private void fillInboundAssociations(Map<String, String> properties) {
		int associationIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_INBOUND_ASSOCIATION_AETITLE
						+ InboundAssociations_DicomServiceStats + associationIndex) != null) {
			VixInboundDicomAssociation association = new VixInboundDicomAssociation();
			association
					.setAeTitle(properties
							.get(VixServerHealthProperties.VIX_INBOUND_ASSOCIATION_AETITLE
									+ InboundAssociations_DicomServiceStats
									+ associationIndex));
			association
					.setIpAddress(properties
							.get(VixServerHealthProperties.VIX_INBOUND_ASSOCIATION_IP_ADDRESS
									+ InboundAssociations_DicomServiceStats
									+ associationIndex));
			association
					.setTotalAcceptedAssociations(properties
							.get(VixServerHealthProperties.VIX_INBOUND_ASSOCIATION_TOTAL_ACCEPTED_ASSOCIATIONS
									+ InboundAssociations_DicomServiceStats
									+ associationIndex));
			association
					.setTotalRejectedAssociations(properties
							.get(VixServerHealthProperties.VIX_INBOUND_ASSOCIATION_TOTAL_REJECTED_ASSOCIATIONS
									+ InboundAssociations_DicomServiceStats
									+ associationIndex));
			association
					.setLastAccessTimestamp(properties
							.get(VixServerHealthProperties.VIX_INBOUND_ASSOCIATION_LAST_ACCESS_TIMESTAMP
									+ InboundAssociations_DicomServiceStats
									+ associationIndex));
			inboundAssociations.add(association);
			associationIndex++;
		}
	}

	private void fillInboundSOPClasses(Map<String, String> properties) {
		int codeIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_INBOUND_SOP_CLASS
						+ InboundSOPClasses_DicomServiceStats + codeIndex) != null) {
			VixInboundDicomSOPClass code = new VixInboundDicomSOPClass();
			code
					.setSopClass(properties
							.get(VixServerHealthProperties.VIX_INBOUND_SOP_CLASS
									+ InboundSOPClasses_DicomServiceStats
									+ codeIndex));
			code
					.setTotalObjectsProcessed(properties
							.get(VixServerHealthProperties.VIX_INBOUND_SOP_CLASS_TOTAL_OBJECTS_PROCESSED
									+ InboundSOPClasses_DicomServiceStats
									+ codeIndex));
			code
					.setTotalObjectsRejected(properties
							.get(VixServerHealthProperties.VIX_INBOUND_SOP_CLASS_TOTAL_OBJECTS_REJECTED
									+ InboundSOPClasses_DicomServiceStats
									+ codeIndex));
			inboundSOPClasses.add(code);
			codeIndex++;
		}
	}

	private void fillPorts(Map<String, String> properties) {
		int portIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_LISTENING_PORT
						+ Port_DicomServiceStats + portIndex) != null) {
			VixDicomPort port = new VixDicomPort();
			port
					.setPortNumber(properties
							.get(VixServerHealthProperties.VIX_LISTENING_PORT
									+ Port_DicomServiceStats
									+ portIndex));
			port
					.setStatus(properties
							.get(VixServerHealthProperties.VIX_LISTENING_PORT_CURRENT_STATUS
									+ Port_DicomServiceStats
									+ portIndex));
			port
					.setListeningSince(properties
							.get(VixServerHealthProperties.VIX_LISTENING_PORT_LIVE_SINCE
									+ Port_DicomServiceStats
									+ portIndex));
			ports.add(port);
			portIndex++;
		}
	}

	private void fillInboundDevices(Map<String, String> properties) {
		int deviceIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_INBOUND_MODALITY_DEVICE_MANUFACTURER
						+ InboundModalityDevices_DicomServiceStats + deviceIndex) != null) {
			VixInboundDicomModalityDevice device = new VixInboundDicomModalityDevice();
			device
					.setManufacturer(properties
							.get(VixServerHealthProperties.VIX_INBOUND_MODALITY_DEVICE_MANUFACTURER
									+ InboundModalityDevices_DicomServiceStats
									+ deviceIndex));
			device
					.setModel(properties
							.get(VixServerHealthProperties.VIX_INBOUND_MODALITY_DEVICE_MODEL
									+ InboundModalityDevices_DicomServiceStats
									+ deviceIndex));
			device
					.setTotalDuplicateInstanceUIDs(properties
							.get(VixServerHealthProperties.VIX_INBOUND_MODALTIY_DEVICE_TOTAL_DUPLICATE_INSTANCE_UIDS
									+ InboundModalityDevices_DicomServiceStats
									+ deviceIndex));
			device
					.setTotalObjectRejected(properties
							.get(VixServerHealthProperties.VIX_INBOUND_MODALITY_DEVICE_TOTAL_OBJECTS_REJECTED
									+ InboundModalityDevices_DicomServiceStats
									+ deviceIndex));
			device
					.setTotalDuplicateObjects(properties
							.get(VixServerHealthProperties.VIX_INBOUND_MODALITY_DEVICE_TOTAL_DUPLICATE_OBJECTS
									+ InboundModalityDevices_DicomServiceStats
									+ deviceIndex));
			device
					.setTotalObjectsProcessed(properties
							.get(VixServerHealthProperties.VIX_INBOUND_MODALITY_DEVICE_TOTAL_OBJECTS_PROCESSED
									+ InboundModalityDevices_DicomServiceStats
									+ deviceIndex));
			device
					.setTotalObjectsWithIODViolations(properties
							.get(VixServerHealthProperties.VIX_INBOUND_MODALITY_DEVICE_TOTAL_OBJECTS_WITH_IOD_VIOLATIONS
									+ InboundModalityDevices_DicomServiceStats
									+ deviceIndex));
			inboundDevices.add(device);
			deviceIndex++;
		}
	}

	private void fillOutboundAssociations(Map<String, String> properties) {
		int associationIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_OUTBOUND_ASSOCIATION_AETITLE
						+ OutboundAssociations_DicomServiceStats + associationIndex) != null) {
			VixOutboundDicomAssociation association = new VixOutboundDicomAssociation();
			association
					.setAeTitle(properties
							.get(VixServerHealthProperties.VIX_OUTBOUND_ASSOCIATION_AETITLE
									+ OutboundAssociations_DicomServiceStats
									+ associationIndex));
			association
					.setTotalAcceptedAssociations(properties
							.get(VixServerHealthProperties.VIX_OUTBOUND_ASSOCIATION_TOTAL_ACCEPTED_ASSOCIATIONS
									+ OutboundAssociations_DicomServiceStats
									+ associationIndex));
			association
					.setTotalRejectedAssociations(properties
							.get(VixServerHealthProperties.VIX_OUTBOUND_ASSOCIATION_TOTAL_REJECTED_ASSOCIATIONS
									+ OutboundAssociations_DicomServiceStats
									+ associationIndex));
			outboundAssociations.add(association);
			associationIndex++;
		}
	}

	private void fillInboundObjects(Map<String, String> properties) {
		int objectIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_INBOUND_OBJECTS_AETITLE
						+ InboundObjects_DicomServiceStats + objectIndex) != null) {
			VixInboundDicomObjects obj = new VixInboundDicomObjects();
			obj
					.setAeTitle(properties
							.get(VixServerHealthProperties.VIX_INBOUND_OBJECTS_AETITLE
									+ InboundObjects_DicomServiceStats
									+ objectIndex));
			obj
					.setTotalObjectsRejected(properties
							.get(VixServerHealthProperties.VIX_INBOUND_OBJECTS_TOTAL_OBJECTS_REJECTED
									+ InboundObjects_DicomServiceStats
									+ objectIndex));
			obj
					.setTotalObjectsProcessed(properties
							.get(VixServerHealthProperties.VIX_INBOUND_OBJECTS_TOTAL_OBJECTS_PROCESSED
									+ InboundObjects_DicomServiceStats
									+ objectIndex));
			obj
					.setTotalObjectsPassedToLegacyGW(properties
							.get(VixServerHealthProperties.VIX_INBOUND_OBJECTS_TOTAL_OBJECTS_PASSED_TO_LEGACY_DGW
									+ InboundObjects_DicomServiceStats
									+ objectIndex));
			obj
					.setTotalObjectsPassedToHDIGDataStructure(properties
							.get(VixServerHealthProperties.VIX_INBOUND_OBJECTS_TOTAL_OBJECTS_PASSED_TO_HDIG_DATA_STRUCTURE
									+ InboundObjects_DicomServiceStats
									+ objectIndex));
			obj
					.setTotalDuplicateObjects(properties
							.get(VixServerHealthProperties.VIX_INBOUND_OBJECTS_TOTAL_DUPLICATE_OBJECTS
									+ InboundObjects_DicomServiceStats
									+ objectIndex));
			inboundObjects.add(obj);
			objectIndex++;
		}
	}

	private void fillOutboundObjects(Map<String, String> properties) {
		int objectIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_OUTBOUND_OBJECTS_AETITLE
						+ OutboundObjects_DicomServiceStats + objectIndex) != null) {
			VixOutboundDicomObjects obj = new VixOutboundDicomObjects();
			obj
					.setAeTitle(properties
							.get(VixServerHealthProperties.VIX_OUTBOUND_OBJECTS_AETITLE
									+ OutboundObjects_DicomServiceStats
									+ objectIndex));
			obj
					.setTotalObjectsTranmittedToSCP(properties
							.get(VixServerHealthProperties.VIX_OUTBOUND_OBJECTS_TOTAL_OBJECTS_TRANSMITTED_TO_SCP
									+ OutboundObjects_DicomServiceStats
									+ objectIndex));
			obj
					.setTotalObjectsRejectedBySCP(properties
							.get(VixServerHealthProperties.VIX_OUTBOUND_OBJECTS_TOTAL_OBJECTS_REJECTED_BY_SCP
									+ OutboundObjects_DicomServiceStats
									+ objectIndex));
			outboundObjects.add(obj);
			objectIndex++;
		}
	}
	
	private void fillInboundDimses(Map<String, String> properties) {
		int codeIndex = 0;
		while (properties
				.get(VixServerHealthProperties.VIX_INBOUND_DIMSE_AETITLE
						+ InboundDimseMessages_DicomServiceStats + codeIndex) != null) {
			VixInboundDicomDimse code = new VixInboundDicomDimse();
			code
					.setAeTitle(properties
							.get(VixServerHealthProperties.VIX_INBOUND_DIMSE_AETITLE
									+ InboundDimseMessages_DicomServiceStats
									+ codeIndex));
			code
					.setDimseServiceName(properties
							.get(VixServerHealthProperties.VIX_INBOUND_DIMSE_SERVICE_NAME
									+ InboundDimseMessages_DicomServiceStats
									+ codeIndex));
			code
					.setTotalProcessedDimseMessages(properties
							.get(VixServerHealthProperties.VIX_INBOUND_DIMSE_TOTAL_PROCESSED_MESSAGES
									+ InboundDimseMessages_DicomServiceStats
									+ codeIndex));
			code
					.setTotalFailedDimseMessages(properties
							.get(VixServerHealthProperties.VIX_INBOUND_DIMSE_TOTAL_REJECTED_MESSAGES
									+ InboundDimseMessages_DicomServiceStats
									+ codeIndex));
			inboundDimses.add(code);
			codeIndex++;
		}
	}


	public List<VixInboundDicomAssociation> getInboundAssociations() {
		return inboundAssociations;
	}

	public List<VixInboundDicomSOPClass> getInboundSOPClasses() {
		return inboundSOPClasses;
	}

	private SimpleDateFormat getDateFormat() {
		return new SimpleDateFormat("MMM d, yyyy h:mm:ss aa");
	}


	public String getDcfLicenseExpirationDate() {
		return dcfLicenseExpirationDate;
	}

	public String getDcfVersion() {
		return dcfVersion;
	}

	public List<VixInboundDicomModalityDevice> getInboundDevices() {
		return inboundDevices;
	}

	public String getJvmStartTime() {
		return jvmStartTime;
	}

	public String getJvmUptime() {
		return jvmUptime;
	}

	public List<VixDicomPort> getPorts() {
		return ports;
	}

	public String getServerName() {
		return serverName;
	}

	public VixServerHealth getVixHealth() {
		return vixHealth;
	}

	public String getVixVersion() {
		return vixVersion;
	}

	/**
	 * @return the inboundDimses
	 */
	public List<VixInboundDicomDimse> getInboundDimses() {
		return inboundDimses;
	}

	/**
	 * @return the inboundObjects
	 */
	public List<VixInboundDicomObjects> getInboundObjects() {
		return inboundObjects;
	}

	/**
	 * @return the outboundAssociations
	 */
	public List<VixOutboundDicomAssociation> getOutboundAssociations() {
		return outboundAssociations;
	}

	/**
	 * @return the outboundObjects
	 */
	public List<VixOutboundDicomObjects> getOutboundObjects() {
		return outboundObjects;
	}

	/**
	 * @return the radObjectsToCorrectFromHDIG
	 */
	public String getRadObjectsToCorrectFromHDIG() {
		return radObjectsToCorrectFromHDIG;
	}

	/**
	 * @return the conObjectsToCorrectFromHDIG
	 */
	public String getConObjectsToCorrectFromHDIG() {
		return conObjectsToCorrectFromHDIG;
	}

	public String getDicomCorrectWorkItemCount() {
		return dicomCorrectWorkItemCount;
	}

	public String getNetworkImportWorkItemCount() {
		return networkImportWorkItemCount;
	}

	public String getStagedMediaWorkItemCount() {
		return stagedMediaWorkItemCount;
	}

	public String getFailedWorkItemCount() {
		return failedWorkItemCount;
	}

	public boolean isServiceAccountValid() {
		return serviceAccountValid;
	}
	
	public boolean isValidCredentials()
	{
		return DicomEngineAdapter.isValidCredentials();
	}
	
	public boolean isDicomStarted()
	{
		return DicomServerConfiguration.getConfiguration().isDicomStarted();
	}
	
	public String getSiteNumber()
	{
		return DicomServerConfiguration.getConfiguration().getSiteId();
	}
		
	public String getSiteName()
	{
		String siteName = "";
		String siteNumber = getSiteNumber();
		
		try
		{
			StorageServerDatabaseConfiguration config = StorageServerDatabaseConfiguration.getConfiguration();
			Place place = config.getPlace(siteNumber);
			siteName = place.getSiteName();
		}
		catch(Exception e)
		{
			logger.error("Unable to find Site Name", e);
		}
		
		return siteName;
		
	}
}
