/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 25, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone  DNS0.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.hdigmanagement.web;

import gov.va.med.imaging.core.router.PeriodicCommandList;
import gov.va.med.imaging.core.router.commands.ProcessEmailQueueCommandImpl;
import gov.va.med.imaging.core.router.commands.ProcessIconImageCreationQueueCommandImpl;
import gov.va.med.imaging.core.router.commands.dicom.ProcessDicomCorrectCommandImpl;
import gov.va.med.imaging.core.router.commands.ProcessAsyncStorageQueueSendEmailCommandImpl;
import gov.va.med.imaging.core.router.periodiccommands.PeriodicCommandEngineAdapter;
import gov.va.med.imaging.dicom.dcftoolkit.startup.DicomEngineAdapter;
import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.facade.configuration.EncryptedConfigurationPropertyString;
import gov.va.med.imaging.facade.configuration.FacadeConfigurationFactory;
import gov.va.med.imaging.notifications.NotificationTypes;
import gov.va.med.imaging.notifications.email.NotificationEmailConfiguration;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * @author      DNS
 *
 */
public class StartOrStopDicomServicesServlet
extends HttpServlet
{
	private static final long serialVersionUID = -1850976585167762873L;
	private final static Logger logger = Logger.getLogger(StartOrStopDicomServicesServlet.class);

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		String action = request.getParameter("action");
		if (action.equals("Cancel"))
		{
			response.sendRedirect("../ViewHDIGStats.jsp");
		}
		else if (!DicomEngineAdapter.isValidCredentials())
		{
			response.sendRedirect("updateServiceAccountCredentials.jsp");
		}
		else if (action.equals("Start DICOM Services"))
		{
			try
			{
				// Start the DICOM services
				DicomEngineAdapter.startDicomServices();
				
				// Kill any existing DICOM periodic commands, just to be safe
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessDicomCorrectCommandImpl.class);
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessIconImageCreationQueueCommandImpl.class);
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessAsyncStorageQueueSendEmailCommandImpl.class);
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessEmailQueueCommandImpl.class);
			
				// Start new periodic commands
				PeriodicCommandEngineAdapter.initializeAndStartPeriodicCommands();
				response.sendRedirect("../secure/startOrStopDicomServices.jsp");
			}
			catch(Exception ex)
			{
				logger.error("Error updating DICOM Server Configuration, " + ex.getMessage(), ex);
				response.sendRedirect("startOrStopServices.jsp?error=There was an error restarting DICOM services ( " + ex.getMessage() + "). The Tomcat service on the HDIG should be restarted.");
			}
		}
		else if (action.equals("Stop DICOM Services"))
		{
			try
			{
				// Stop the DICOM services
				DicomEngineAdapter.stopListeners();

				// Kill any existing periodic commands
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessDicomCorrectCommandImpl.class);
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessIconImageCreationQueueCommandImpl.class);
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessAsyncStorageQueueSendEmailCommandImpl.class);
				PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessEmailQueueCommandImpl.class);

				// Start new periodic commands
				PeriodicCommandEngineAdapter
						.initializeAndStartPeriodicCommands();

				response.sendRedirect("../secure/startOrStopDicomServices.jsp");
			}
			catch(Exception ex)
			{
				logger.error("Error updating DICOM Server Configuration, " + ex.getMessage(), ex);
				response.sendRedirect("../secure/startOrStopDicomServices.jsp?error=There was an error restarting DICOM services ( " + ex.getMessage() + "). The Tomcat service on the HDIG should be restarted.");
			}
		}
	}

}
