/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 25, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:       DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone ( DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.hdigmanagement.web;

import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.notifications.NotificationTypes;
import gov.va.med.imaging.notifications.email.NotificationEmailConfiguration;
import gov.va.med.imaging.dicom.dcftoolkit.startup.DicomEngineAdapter;

import javax.servlet.jsp.JspException;

/**
 * @author       DNS
 *
 */
public class HDIGConfigurationView
{
	private final String accessCode;
	private final String verifyCode;
	private final String notificationEmailAddresses;

	
	public static HDIGConfigurationView get()
	throws JspException
	{		
		DicomServerConfiguration configuration = DicomServerConfiguration.getConfiguration();
		String accessCode = configuration.getAccessCodeString();
		String verifyCode = configuration.getVerifyCodeString();
		String email = getEmailsAsDelimitedString();
		return new HDIGConfigurationView(accessCode, verifyCode, email);
	}


	private static String getEmailsAsDelimitedString() 
	{
		NotificationEmailConfiguration config = NotificationEmailConfiguration.getConfiguration();
		return config.getRecipientsForNotificationTypeAsDelimitedString(NotificationTypes.InvalidServiceAccountCredentials);
	}


	public HDIGConfigurationView(String accessCode, String verifyCode,
			String notificationEmailAddresses)
	{
		super();
		this.accessCode = accessCode;
		this.verifyCode = verifyCode;
		this.notificationEmailAddresses = notificationEmailAddresses;
	}

	public String getAccessCode()
	{
		return accessCode;
	}

	public String getVerifyCode()
	{
		return verifyCode;
	}

	public String getNotificationEmailAddresses()
	{
		return notificationEmailAddresses;
	}
	
	public boolean isValidCredentials()
	{
		return DicomEngineAdapter.isValidCredentials();
	}
}
