/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 19, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.hdigmanagement.configuration;

import gov.va.med.imaging.facade.configuration.AbstractBaseFacadeConfiguration;
import gov.va.med.imaging.facade.configuration.FacadeConfigurationFactory;
import gov.va.med.imaging.facade.configuration.exceptions.CannotLoadConfigurationException;

/**
 * @author vhaiswwerfej
 *
 */
public class HDIGManagementWebAppConfiguration 
extends AbstractBaseFacadeConfiguration 
{
	private Integer reloadPageIntervalSeconds = null;
	
	public HDIGManagementWebAppConfiguration()
	{
		super();
	}
	
	/**
	 * @return the reloadPageIntervalSeconds
	 */
	public Integer getReloadPageIntervalSeconds() {
		return reloadPageIntervalSeconds;
	}

	/**
	 * @param reloadPageIntervalSeconds the reloadPageIntervalSeconds to set
	 */
	public void setReloadPageIntervalSeconds(Integer reloadPageIntervalSeconds) {
		this.reloadPageIntervalSeconds = reloadPageIntervalSeconds;
	}
	
	public static synchronized HDIGManagementWebAppConfiguration getHDIGManagementWebAppConfiguration()
	{
		try
		{
			return FacadeConfigurationFactory.getConfigurationFactory().getConfiguration(
					HDIGManagementWebAppConfiguration.class);
		}
		catch(CannotLoadConfigurationException clcX)
		{
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.facade.configuration.AbstractBaseFacadeConfiguration#loadDefaultConfiguration()
	 */
	@Override
	public AbstractBaseFacadeConfiguration loadDefaultConfiguration() 
	{
		this.reloadPageIntervalSeconds = 300; // 5 minutes
		return this;
	}

	public static void main(String [] args)
	{
		HDIGManagementWebAppConfiguration config = HDIGManagementWebAppConfiguration.getHDIGManagementWebAppConfiguration();
		config.loadDefaultConfiguration();
		config.storeConfiguration();
	}

}
