<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@page
	import="gov.va.med.imaging.hdigmanagement.web.HDIGConfigurationView;"%>
<%@ taglib uri='http://java.sun.com/jsp/jstl/core' prefix='c' %>
	
<%
String path = request.getContextPath();
String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/";

HDIGConfigurationView hdigConfigurationView = HDIGConfigurationView.get();
	pageContext.setAttribute("view", hdigConfigurationView);
	
	String result = request.getParameter("result");
	String error = request.getParameter("error");
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
  <head>
    <title>HDIG Configuration</title>
    
	<meta http-equiv="pragma" content="no-cache">
	<meta http-equiv="cache-control" content="no-cache">
	<meta http-equiv="expires" content="0">    
	<meta http-equiv="keywords" content="hdig, vista, imaging">
	<link rel="stylesheet" type="text/css" href="../style/vix.css">
	
	<script type="text/javascript">
		function setAccessFocus() 
		{
			document.getElementById("accessCode").focus();
		}
		
		function validateInput()
		{
			var accessCodeValue = document.getElementById("accessCode").value;
			if(accessCodeValue == null || accessCodeValue == "")
			{
				alert('You must specify an access code');
				return false;
			}
			var verifyCodeValue = document.getElementById("verifyCode").value;
			if(verifyCodeValue == null || verifyCodeValue == "")
			{
				alert('You must specify a verify code');
				return false;
			}
			
			return true;
		}
		
	</script>

  </head>
  
  <body onLoad="setAccessFocus();">
  	<jsp:useBean id="view"
			type="gov.va.med.imaging.hdigmanagement.web.HDIGConfigurationView"
			scope="page" />
  	<div id="header">
		Configure HDIG
	</div>	
	
	<c:if test="${view.validCredentials == true}">
		<div id="content">  		
		
	  		<div id="main-content">
			    <h2>Service Account Credentials Are Valid</h2>
			    The service account credentials are currently valid. Please change the
			    credentials first on VistA, and then return here to update them on the HDIG.
			    <br />
			    <br />
			    <a href="../ViewHDIGStats.jsp">Return to the HDIG Statistics page</a>
	   		</div>
	  	</div>
	</c:if>  	
  	
  	<c:if test="${view.validCredentials == false}">
  	
	  	<div id="content">  		
	  		<div id="main-content">
			    <h2>Update Service Account Credentials:</h2>
			    <%
			    	if(error != null)
			    	{
			    		%>
			    		<div id="error"><%= error %></div><br>
			    		<%
		    		}		    
			     %>		    
			    
			    The HDIG service account credentials are currently invalid. The HDIG needs these credentials to run periodic commands and DICOM listeners.
			    <br/>
			    <br/>
			    Please enter valid service account credentials below, and then click 'Save Credentials':
			    <br/>
			    <br/>
			    <form method="POST" action="UpdateServiceAccountCredentials" onsubmit="return validateInput()">
				    <table border="1">
				    	<tr>
				    		<th>Access Code:</th>
				    		<td><input type="password" id="accessCode" name="accessCode" /></td>
				    	</tr>
				    	<tr>
				    		<th>Verify Code:</th>
				    		<td><input type="password" id="verifyCode" name="verifyCode" /></td>
				    	</tr>
				    </table>
			    	<br>
			   		<input type="submit" name="action" value="Save Credentials and Restart Services"/>
			   		<input type="submit" name="action" value="Cancel"/>
			   	</form>
			   	<br />
					<a href="../ViewHDIGStats.jsp">Return to the HDIG statistics page</a>
				<br />
			   		 
	   		</div>
	  	</div>
	</c:if>  	
  	<jsp:include flush="false" page="../footer.html"></jsp:include>
    
  </body>
</html>
