<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%@page
	import="gov.va.med.imaging.hdigmanagement.configuration.HDIGManagementWebAppConfiguration"%>
<%@page
	import="gov.va.med.imaging.hdigmanagement.web.VixDicomServerHealthView;"%>
<%@ taglib uri='http://java.sun.com/jsp/jstl/core' prefix='c' %>
<%@ taglib uri='http://java.sun.com/jsp/jstl/functions' prefix='fn' %>

<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://"
			+ request.getServerName() + ":" + request.getServerPort()
			+ path + "/";

	VixDicomServerHealthView viewVixDicomview = VixDicomServerHealthView
			.get();
	pageContext.setAttribute("view", viewVixDicomview);

	Integer refreshInterval = HDIGManagementWebAppConfiguration
			.getHDIGManagementWebAppConfiguration()
			.getReloadPageIntervalSeconds();
	if (refreshInterval == null)
		refreshInterval = 120;
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<title>View HDIG Statistics</title>

		<meta http-equiv="pragma" content="no-cache">
		<meta http-equiv="cache-control" content="no-cache">
		<meta http-equiv="expires" content="0">
		<meta http-equiv="keywords" content="keyword1,keyword2,keyword3">
		<meta http-equiv="description" content="This is my page">
		<meta http-equiv="refresh" content="<%=refreshInterval%>">
		<link rel="stylesheet" type="text/css" href="style/vix.css">
	</head>

	<body>
		<jsp:useBean id="view"
			type="gov.va.med.imaging.hdigmanagement.web.VixDicomServerHealthView"
			scope="page" />
		<div id="header">
			View HDIG Statistics
		</div>
		<div id="main-content">
			<blockquote><h2> 
				Basic Information 
			</h2></blockquote>
			<br />
			<a href="/Vix/ssl/JavaLogs.jsp">Access Java Logs Viewer</a>
			<br />
			<br />			
			<c:if test="${view.validCredentials == false}">
				<div id="error">
					The credentials for the HDIG service account are currently invalid, so DICOM services are unable to run. 
					Please update the credentials using the link below to restore HDIG functionality.
				</div>
				<br />
			</c:if> 
				<a href="secure/updateServiceAccountCredentials.jsp">Update the HDIG service account credentials</a>
				<br />
				<a href="secure/updateAdminEmail.jsp">Update the Administrator email address(es)</a>
				<br />
				<br />
			<table border="1">
				<tr>
					<th>
						Hostname:
					</th>
					<td>
						<jsp:getProperty name="view" property="serverName" />
					</td>
				</tr>
				<tr>
					<th>
						Site Number:
					</th>
					<td>
						<jsp:getProperty name="view" property="siteNumber" />
					</td>
				</tr>
				<tr>
					<th>
						Site Name:
					</th>
					<td>
						<jsp:getProperty name="view" property="siteName" />
					</td>
				</tr>
				<tr>
					<th>
						Version:
					</th>
					<td>
						<jsp:getProperty name="view" property="vixVersion" />
					</td>
				</tr>
				<tr>
					<th>
						JVM Start Time:
					</th>
					<td>
						<jsp:getProperty name="view" property="jvmStartTime" />
					</td>
				</tr>
				<tr>
					<th>
						JVM Up Time:
					</th>
					<td>
						<jsp:getProperty name="view" property="jvmUptime" />
					</td>
				</tr>
			</table>
			<br />
			<table border="1">
				<tr>
					<th>
						DCF Version:
					</th>
					<td>
						<jsp:getProperty name="view" property="dcfVersion" />
					</td>
				</tr>
				<tr>
					<th>
						DCF License Expiration Date:
					</th>
					<td>
						<jsp:getProperty name="view" property="dcfLicenseExpirationDate" />
					</td>
				</tr>
			</table>
			<br />
			<table border="1">
				<tr>
					<th>
						RAD Objects in DICOM FAILED IMAGES File (#2006.575) from this HDIG:
					</th>
					<td>
						<jsp:getProperty name="view" property="radObjectsToCorrectFromHDIG" />
					</td>
				</tr>
				<tr>
					<th>
						CON Objects in DICOM FAILED IMAGES File (#2006.575) from this HDIG:
					</th>
					<td>
						<jsp:getProperty name="view" property="conObjectsToCorrectFromHDIG" />
					</td>
				</tr>
			</table>
			<br />
			<table border="1">
				<tr>
					<th>
						Total New DICOM Correct Work Items:
					</th>
					<td>
						<jsp:getProperty name="view" property="dicomCorrectWorkItemCount" />
					</td>
				</tr>
				<tr>
					<th>
						Total New Network Import Work Items:
					</th>
					<td>
						<jsp:getProperty name="view" property="networkImportWorkItemCount" />
					</td>
				</tr>
				<tr>
					<th>
						Total New Staged Media Work Items:
					</th>
					<td>
						<jsp:getProperty name="view" property="stagedMediaWorkItemCount" />
					</td>
				</tr>
				<tr>
					<th>
						Total Failed Work Items:
					</th>
					<td>
						<jsp:getProperty name="view" property="failedWorkItemCount" />
					</td>
				</tr>
			</table>
			<br><br />
			<blockquote><h2> 
				Inbound Activity 
			</h2></blockquote>
			<div>
				<b>Note:</b> AE Titles are represented in upper case for all Inbound Activity.
			</div>
			
			
			<h3> 
				DICOM Listening Ports: 
			</h3>
			<c:forEach var="port" items="${view.ports}">
				<table border="1">
				<tr>
					<th>
							Port Number:
					</th>
					<td>
							<c:out value="${port.portNumber}" />
					</td>
				</tr>
				<tr>
					<th>
							Status:
						</th>
						<td>
							<c:out value="${port.status}" />
						</td>
					</tr>
					<tr>
						<th>
							Listening Since:
						</th>
						<td>
							<c:out value="${port.listeningSince}" />
							
						</td>
					</tr>
				</table>
				<br />
			</c:forEach>

			
			<h3> 
				Inbound Associations: 
			</h3>
			<c:forEach var="inassociation" items="${view.inboundAssociations}">
				<table border="1">
					<tr>
						<th>
							AE Title:
						</th>
						<td>
							<c:out value="${inassociation.aeTitle}" />
						</td>
					</tr>
					<tr>
						<th>
							IP Address:
					</th>
					<td>
							<c:out value="${inassociation.ipAddress}" />
					</td>
				</tr>
				<tr>
					<th>
							Total Accepted Associations:
						</th>
						<td>
							<c:out value="${inassociation.totalAcceptedAssociations}" />
							
						</td>
					</tr>
					<tr>
						<th>
							Total Rejected Associations:
						</th>
						<td>
							<c:out value="${inassociation.totalRejectedAssociations}" />
						</td>
					</tr>
				<tr>
					<th>
							Last Access Timestamp:
					</th>
					<td>
							<c:out value="${inassociation.lastAccessTimestamp}" />
					</td>
				</tr>
			</table>
			
			<br />
			</c:forEach>
			
			
			<h3> 
				Inbound Dimse Messages: 
			</h3>
			<c:forEach var="dimse" items="${view.inboundDimses}">
				<table border="1">
					<tr>
						<th>
							AE Title:
						</th>
						<td>
							<c:out value="${dimse.aeTitle}" />
						</td>
					</tr>
					<tr>
						<th>
							Dimse Service:
						</th>
						<td>
							<c:out value="${dimse.dimseServiceName}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Dimse Messages Processed:
						</th>
						<td>
							<c:out value="${dimse.totalProcessedDimseMessages}" />
							
						</td>
					</tr>
					<tr>
						<th>
							Total Dimse Messages Rejected:
						</th>
						<td>
							<c:out value="${dimse.totalFailedDimseMessages}" />
							
						</td>
					</tr>
				</table>
				<br />
			</c:forEach>


			
			<h3> 
				Inbound Objects: 
			</h3>
			<c:forEach var="dinobject" items="${view.inboundObjects}">
				<table border="1">
					<tr>
						<th>
							AE Title:
						</th>
						<td>
							<c:out value="${dinobject.aeTitle}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Processed:
						</th>
						<td>
							<c:out value="${dinobject.totalObjectsProcessed}" />
							
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Rejected:
						</th>
						<td>
							<c:out value="${dinobject.totalObjectsRejected}" />
							
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Passed to Legacy Gateway:
						</th>
						<td>
							<c:out value="${dinobject.totalObjectsPassedToLegacyGW}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Passed to HDIG Data Structure:
						</th>
						<td>
							<c:out value="${dinobject.totalObjectsPassedToHDIGDataStructure}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Duplicate Objects (RESENDs):
						</th>
						<td>
							<c:out value="${dinobject.totalDuplicateObjects}" />
							
						</td>
					</tr>
				</table>
				<br />
			</c:forEach>
			
			
			<h3> 
				Inbound Modality Devices: 
			</h3>
			<c:forEach var="device" items="${view.inboundDevices}">
				<table border="1">
					<tr>
						<th>
							Manufacturer:
						</th>
						<td>
							<c:out value="${device.manufacturer}" />
						</td>
					</tr>
					<tr>
						<th>
							Model:
						</th>
						<td>
							<c:out value="${device.model}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Processed:
						</th>
						<td>
							<c:out value="${device.totalObjectsProcessed}" />
							
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Rejected:
						</th>
						<td>
							<c:out value="${device.totalObjectRejected}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Duplicate Objects (RESENDs):
						</th>
						<td>
							<c:out value="${device.totalDuplicateObjects}" />
						</td>
					</tr>
					<tr>
						<th> 
							Total Objects with a Duplicate Instance UID: 
						</th>
						<td>
							<c:out value="${device.totalDuplicateInstanceUIDs}" />
							
						</td>
					</tr>
					<tr>
						<th>
							Total Objects with IOD Violations:
						</th>
						<td>
							<c:out value="${device.totalObjectsWithIODViolations}" />
						</td>
					</tr>
				</table>
				<br />
			</c:forEach>
			
			
			<h3> 
				Inbound SOP Classes: 
			</h3>
			<c:forEach var="sop" items="${view.inboundSOPClasses}">
				<table border="1">
					<tr>
						<th>
							SOP Class:
						</th>
						<td>
							<c:out value="${sop.sopClass}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Processed:
						</th>
						<td>
							<c:out value="${sop.totalObjectsProcessed}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Rejected:
						</th>
						<td>
							<c:out value="${sop.totalObjectsRejected}" />
						</td>
					</tr>
				</table>
				<br />
			</c:forEach>
			
			<br />
			<blockquote><h2> 
				Outbound Activity 
			</h2></blockquote>
			
			<h3> 
				Outbound Associations: 
			</h3>
			<c:forEach var="outassociation" items="${view.outboundAssociations}">
				<table border="1">
					<tr>
						<th>
							AE Title:
						</th>
						<td>
							<c:out value="${outassociation.aeTitle}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Accepted Associations:
						</th>
						<td>
							<c:out value="${outassociation.totalAcceptedAssociations}" />
							
						</td>
					</tr>
					<tr>
						<th>
							Total Rejected Associations:
						</th>
						<td>
							<c:out value="${outassociation.totalRejectedAssociations}" />
						</td>
					</tr>
				</table>
				<br />
			</c:forEach>

			
			<h3>
				Outbound Objects:
			</h3>
			<c:forEach var="doutobject" items="${view.outboundObjects}">
				<table border="1">
					<tr>
						<th>
							AE Title:
						</th>
						<td>
							<c:out value="${doutobject.aeTitle}" />
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Transmitted:
						</th>
						<td>
							<c:out value="${doutobject.totalObjectsTranmittedToSCP}" />							
							
						</td>
					</tr>
					<tr>
						<th>
							Total Objects Rejected:
						</th>
						<td>
							<c:out value="${doutobject.totalObjectsRejectedBySCP}" />
						</td>
					</tr>
				</table>
				<br />
			</c:forEach>
		</div>
		<jsp:include flush="false" page="footer.html"></jsp:include>
	</body>
</html>
